/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;

public class Utils {
    public static String md5(String str) {
        if (str == null) {
            return "";
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = md.digest();
            StringBuffer sb = new StringBuffer(bytes.length * 2);
            byte[] byArray = bytes;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte b = byArray[i];
                sb.append(hexDigits[b >> 4 & 0xF]);
                sb.append(hexDigits[b & 0xF]);
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String bytesToBase64URL(byte[] bytes) {
        String base64 = Base64.getEncoder().encodeToString(bytes);
        return "data:image/png;base64," + base64;
    }

    /*
     * Exception decompiling
     */
    public static byte[] readFile(Path filePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String readTextFile(Path filePath) throws IOException {
        return new String(Utils.readFile(filePath), StandardCharsets.UTF_8);
    }

    public static void writeTextFile(Path filePath, String content) throws IOException {
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new IOException("Cannot find the specified file.");
        }
        String[] splitted = content.split("\n");
        try (FileWriter fw = new FileWriter(filePath.toString());){
            for (int i = 0; i < splitted.length; ++i) {
                fw.write(splitted[i] + "\n");
            }
        }
    }

    public static String decompressTextGzip(Path gzipPath) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (FileInputStream fis = new FileInputStream(gzipPath.toString());
             GZIPInputStream gis = new GZIPInputStream(fis);
             InputStreamReader isr = new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(isr);){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static void deleteDirectoryRecursively(Path dirPath) throws IOException {
        if (!Files.exists(dirPath, new LinkOption[0])) {
            throw new IOException("The given path doesn't exist.");
        }
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path subDir, IOException e) throws IOException {
                Files.delete(subDir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void clearDirectoryRecursively(final Path dirPath) throws IOException {
        if (!Files.exists(dirPath, new LinkOption[0])) {
            throw new IOException("The given path doesn't exist.");
        }
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path subDir, IOException e) throws IOException {
                if (!subDir.equals(dirPath)) {
                    Files.delete(subDir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copyDirectoryRecursively(final Path sourcePath, final Path targetPath) throws IOException {
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
                Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path subDir, BasicFileAttributes attr) throws IOException {
                try {
                    Files.copy(subDir, targetPath.resolve(sourcePath.relativize(subDir)), StandardCopyOption.COPY_ATTRIBUTES);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static long getDirectorySize(Path dirPath) throws IOException {
        if (!Files.exists(dirPath, new LinkOption[0]) || !Files.isDirectory(dirPath, new LinkOption[0])) {
            throw new IOException("Cannot find the directory.");
        }
        try (Stream<Path> stream = Files.walk(dirPath, new FileVisitOption[0]);){
            long l = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).mapToLong(path -> {
                try {
                    return Files.size(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0L;
                }
            }).sum();
            return l;
        }
    }
}

