/*
 * Decompiled with CFR 0.152.
 */
package net.opanel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import net.opanel.OPanelConfiguration;
import net.opanel.Uptimer;
import net.opanel.common.OPanelServer;
import net.opanel.logger.Loggable;
import net.opanel.terminal.LogListenerManager;
import net.opanel.utils.TPS;
import net.opanel.utils.Utils;
import net.opanel.web.WebServer;

public class OPanel {
    public static final String VERSION;
    public static final Path OPANEL_DIR_PATH;
    public static final Path TMP_DIR_PATH;
    private final OPanelConfiguration config;
    public final Loggable logger;
    private Uptimer uptimer;
    private WebServer webServer;
    private OPanelServer server;
    private LogListenerManager logListenerManager;

    public OPanel(OPanelConfiguration config, Loggable logger) {
        this.config = config;
        this.logger = logger;
        this.uptimer = new Uptimer();
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.webServer = new WebServer(this);
    }

    private void init() throws IOException {
        File opanelDir = new File(OPANEL_DIR_PATH.toString());
        if (!opanelDir.exists() && !opanelDir.mkdir()) {
            throw new IOException("Cannot initialize .opanel directory.");
        }
        File tmpDir = new File(TMP_DIR_PATH.toString());
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            throw new IOException("Cannot initialize .opanel/tmp directory.");
        }
        if (tmpDir.list().length > 0) {
            Utils.clearDirectoryRecursively(tmpDir.toPath());
        }
    }

    public void onTick() {
        TPS.onTick();
    }

    public OPanelConfiguration getConfig() {
        return this.config;
    }

    public Uptimer getUptimer() {
        return this.uptimer;
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void setServer(OPanelServer server) {
        this.server = server;
    }

    public OPanelServer getServer() {
        return this.server;
    }

    public void setLogListenerManager(LogListenerManager manager) {
        this.logListenerManager = manager;
    }

    public LogListenerManager getLogListenerManager() {
        return this.logListenerManager;
    }

    public void stop() {
        try {
            this.webServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a76\u00a7lOPanel \u00a7r\u00a7fStatus\n");
        sb.append("\u00a7r\u00a77Version: \u00a7f").append(VERSION).append("\n");
        sb.append("\u00a7r\u00a77Status: ").append(this.getWebServer().isRunning() ? "\u00a7aRunning" : "\u00a7cStopped").append("\n");
        sb.append("\u00a7r\u00a77Port: \u00a7f").append(this.getConfig().webServerPort).append("\n");
        sb.append("\u00a7r\u00a77Jetty Version: \u00a7f").append(this.getWebServer().getJettyVersion());
        return sb.toString();
    }

    static {
        String version;
        OPANEL_DIR_PATH = Paths.get("", new String[0]).resolve(".opanel");
        TMP_DIR_PATH = OPANEL_DIR_PATH.resolve("tmp");
        try (InputStream is = OPanel.class.getClassLoader().getResourceAsStream("opanel.properties");){
            Properties props = new Properties();
            props.load(is);
            version = props.getProperty("version");
        }
        catch (IOException e) {
            e.printStackTrace();
            version = null;
        }
        VERSION = version;
    }
}

