/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.utils.Utils;
import net.opanel.web.BaseServlet;

public class AuthServlet
extends BaseServlet {
    public static final String route = "/api/auth";

    public AuthServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        RequestBodyType reqBody = this.getRequestBody(req, RequestBodyType.class);
        if (reqBody.accessKey == null) {
            this.sendResponse(res, 400);
            return;
        }
        String submittedKey = reqBody.accessKey;
        String hashedRealKey = this.plugin.getConfig().accessKey;
        String hashedSubmittedKey = Utils.md5(submittedKey);
        if (hashedSubmittedKey.equals(hashedRealKey)) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("token", Utils.md5(this.plugin.getConfig().salt + hashedRealKey));
            this.sendResponse(res, obj);
        } else {
            this.sendResponse(res, 401);
        }
    }

    private class RequestBodyType {
        String accessKey;

        private RequestBodyType(AuthServlet authServlet) {
        }
    }
}

