/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.utils;

public class TPS {
    public static final int TICK_LIST_SIZE = 100;
    private static final long PAUSE_THRESHOLD_NS = 2000000000L;
    private static long[] tickTimes = new long[100];
    private static int tickIndex = 0;

    public static void onTick() {
        TPS.tickTimes[TPS.tickIndex] = System.nanoTime();
        tickIndex = (tickIndex + 1) % 100;
    }

    public static double getRecentMSPT() {
        long totalTime = 0L;
        int ticks = 0;
        for (int i = 0; i < 100; ++i) {
            long start = tickTimes[i];
            long end = tickTimes[(i + 1) % 100];
            if (start == 0L || end == 0L || end < start) continue;
            totalTime += end - start;
            ++ticks;
        }
        return (double)totalTime / (double)ticks / 1000000.0;
    }

    public static double getRecentTPS() {
        double tps = 1000.0 / TPS.getRecentMSPT();
        return Math.min(20.0, tps);
    }

    public static boolean isPaused() {
        long current = System.nanoTime();
        int lastIndex = tickIndex - 1;
        if (lastIndex < 0) {
            lastIndex += 100;
        }
        return current - tickTimes[lastIndex] >= 2000000000L;
    }
}

