/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.logger.Loggable;
import net.opanel.web.BaseServlet;

public class LogsServlet
extends BaseServlet {
    public static final String route = "/api/logs/*";

    public LogsServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        Loggable logger = this.plugin.logger;
        if (reqPath == null || reqPath.equals("/")) {
            try {
                HashMap<String, Object> obj = new HashMap<String, Object>();
                obj.put("logs", logger.getLogFileList());
                this.sendResponse(res, obj);
            }
            catch (IOException e) {
                this.sendResponse(res, 500, e.getMessage());
            }
        } else if (reqPath.startsWith("/")) {
            String fileName = reqPath.substring(1);
            try {
                this.sendContentResponse(res, logger.getLogContent(fileName).getBytes(StandardCharsets.UTF_8), "application/octet-stream");
            }
            catch (IOException e) {
                this.sendResponse(res, 404, e.getMessage());
            }
        } else {
            this.sendResponse(res, 400);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        Loggable logger = this.plugin.logger;
        if (reqPath == null || reqPath.equals("/")) {
            try {
                for (String fileName : logger.getLogFileList()) {
                    if (!fileName.endsWith(".log.gz")) continue;
                    logger.deleteLog(fileName);
                }
                this.sendResponse(res, 200);
            }
            catch (IOException e) {
                this.sendResponse(res, 500, e.getMessage());
            }
            return;
        }
        if (!reqPath.startsWith("/")) {
            this.sendResponse(res, 400);
            return;
        }
        try {
            logger.deleteLog(reqPath.substring(1));
        }
        catch (IOException e) {
            this.sendResponse(res, 404, e.getMessage());
            return;
        }
        this.sendResponse(res, 200);
    }
}

