/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import net.opanel.OPanel;
import net.opanel.common.OPanelServer;
import net.opanel.common.OPanelWhitelist;
import net.opanel.deps.gson.reflect.TypeToken;
import net.opanel.web.BaseServlet;

public class WhitelistServlet
extends BaseServlet {
    public static final String route = "/api/whitelist/*";

    public WhitelistServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        OPanelServer server = this.plugin.getServer();
        OPanelWhitelist whitelist = server.getWhitelist();
        try {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("whitelist", whitelist.getEntries());
            this.sendResponse(res, obj);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(res, 500);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        OPanelWhitelist whitelist = server.getWhitelist();
        String name = req.getParameter("name");
        String uuid = req.getParameter("uuid");
        try {
            switch (reqPath.substring(1)) {
                case "enable": {
                    server.setWhitelistEnabled(true);
                    break;
                }
                case "disable": {
                    server.setWhitelistEnabled(false);
                    break;
                }
                case "write": {
                    whitelist.write((List)this.getRequestBody(req, new TypeToken<List<OPanelWhitelist.OPanelWhitelistEntry>>(this){}.getType()));
                    break;
                }
                case "add": {
                    if (name == null || uuid == null) {
                        this.sendResponse(res, 400);
                        return;
                    }
                    whitelist.add(new OPanelWhitelist.OPanelWhitelistEntry(name, uuid));
                    break;
                }
                case "remove": {
                    if (name == null || uuid == null) {
                        this.sendResponse(res, 400);
                        return;
                    }
                    whitelist.remove(new OPanelWhitelist.OPanelWhitelistEntry(name, uuid));
                }
            }
            this.sendResponse(res, 200);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(res, 500);
        }
    }
}

