/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_1_21;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.opanel.logger.Loggable;
import net.opanel.utils.Utils;
import org.slf4j.Logger;

public class LoggerImpl
implements Loggable {
    private static final Path logFolderPath = Paths.get("", new String[0]).resolve("logs");
    private final Logger logger;

    LoggerImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void info(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void warn(String msg) {
        this.logger.warn(msg);
    }

    @Override
    public void error(String msg) {
        this.logger.error(msg);
    }

    @Override
    public List<String> getLogFileList() throws IOException {
        if (!Files.exists(logFolderPath, new LinkOption[0])) {
            Files.createDirectory(logFolderPath, new FileAttribute[0]);
        }
        if (!Files.isDirectory(logFolderPath, new LinkOption[0])) {
            throw new IOException("Cannot find the logs folder, but found a logs file.");
        }
        ArrayList<String> fileList = new ArrayList<String>();
        try (Stream<Path> stream = Files.list(logFolderPath);){
            stream.filter(item -> !Files.isDirectory(item, new LinkOption[0])).map(Path::getFileName).forEach(name -> fileList.add(name.toString()));
        }
        return fileList;
    }

    @Override
    public String getLogContent(String fileName) throws IOException {
        Path filePath = Paths.get(logFolderPath.toString(), fileName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new IOException("Cannot find the specified log file.");
        }
        if (filePath.toString().endsWith(".log") || filePath.toString().endsWith("txt")) {
            return Utils.readTextFile(filePath);
        }
        if (filePath.toString().endsWith(".gz")) {
            return Utils.decompressTextGzip(filePath);
        }
        throw new IOException("Unexpected file extension.");
    }

    @Override
    public void deleteLog(String fileName) throws IOException {
        Path filePath = Paths.get(logFolderPath.toString(), fileName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new IOException("Cannot find the specified log file.");
        }
        Files.delete(filePath);
    }
}

