/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.neoforge_1_21_5;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.LevelResource;
import net.opanel.ServerType;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.common.OPanelWhitelist;
import net.opanel.neoforge_1_21_5.NeoOfflinePlayer;
import net.opanel.neoforge_1_21_5.NeoPlayer;
import net.opanel.neoforge_1_21_5.NeoSave;
import net.opanel.neoforge_1_21_5.NeoWhitelist;

public class NeoServer
implements OPanelServer {
    private final MinecraftServer server;
    private final DedicatedServer dedicatedServer;

    public NeoServer(MinecraftServer server) {
        this.server = server;
        this.dedicatedServer = (DedicatedServer)server;
    }

    @Override
    public ServerType getServerType() {
        return ServerType.FORGE;
    }

    @Override
    public byte[] getFavicon() {
        ServerStatus status = this.server.getStatus();
        if (status == null) {
            return null;
        }
        Optional faviconOptional = status.favicon();
        if (faviconOptional.isEmpty()) {
            return null;
        }
        ServerStatus.Favicon favicon = (ServerStatus.Favicon)faviconOptional.get();
        return favicon.iconBytes();
    }

    @Override
    public String getMotd() {
        return this.server.getMotd();
    }

    @Override
    public void setMotd(String motd) throws IOException {
        this.server.setMotd(motd);
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("motd=.+", "motd=" + motd));
        DedicatedServerProperties properties = this.dedicatedServer.getProperties();
        try {
            Field motdField = properties.getClass().getDeclaredField("motd");
            motdField.setAccessible(true);
            motdField.set(properties, motd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getVersion() {
        return this.server.getServerVersion();
    }

    @Override
    public int getPort() {
        return this.server.getPort();
    }

    @Override
    public List<OPanelSave> getSaves() {
        ArrayList<OPanelSave> list = new ArrayList<OPanelSave>();
        try (Stream<Path> stream = Files.list(Paths.get("", new String[0]));){
            stream.filter(path -> Files.exists(path.resolve("level.dat"), new LinkOption[0]) && !Files.isDirectory(path.resolve("level.dat"), new LinkOption[0])).map(Path::toAbsolutePath).forEach(path -> {
                NeoSave save = new NeoSave(this.server, (Path)path);
                list.add(save);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public OPanelSave getSave(String saveName) {
        Path savePath = Paths.get("", new String[0]).resolve(saveName);
        if (!Files.exists(savePath, new LinkOption[0]) || !Files.exists(savePath.resolve("level.dat"), new LinkOption[0])) {
            return null;
        }
        return new NeoSave(this.server, savePath.toAbsolutePath());
    }

    @Override
    public void saveAll() {
        this.server.saveEverything(true, true, true);
    }

    @Override
    public List<OPanelPlayer> getOnlinePlayers() {
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>();
        List players = this.server.getPlayerList().getPlayers();
        for (ServerPlayer serverPlayer : players) {
            NeoPlayer player = new NeoPlayer(serverPlayer);
            list.add(player);
        }
        return list;
    }

    @Override
    public List<OPanelPlayer> getPlayers() {
        Path playerDataPath = this.server.getWorldPath(LevelResource.PLAYER_DATA_DIR);
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>(this.getOnlinePlayers());
        try (Stream<Path> stream = Files.list(playerDataPath);){
            stream.filter(item -> !Files.isDirectory(item, new LinkOption[0]) && item.toString().endsWith(".dat")).forEach(item -> {
                String uuid = item.getFileName().toString().replace(".dat", "");
                ServerPlayer serverPlayer = this.server.getPlayerList().getPlayer(UUID.fromString(uuid));
                if (serverPlayer != null && !serverPlayer.hasDisconnected()) {
                    return;
                }
                try {
                    NeoOfflinePlayer player = new NeoOfflinePlayer(this.server, UUID.fromString(uuid));
                    list.add(player);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getMaxPlayerCount() {
        return this.server.getMaxPlayers();
    }

    @Override
    public OPanelPlayer getPlayer(String uuid) {
        for (OPanelPlayer player : this.getPlayers()) {
            if (!player.getUUID().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.server.getPlayerList().isUsingWhitelist();
    }

    @Override
    public void setWhitelistEnabled(boolean enabled) {
        this.server.getPlayerList().setUsingWhiteList(enabled);
    }

    @Override
    public OPanelWhitelist getWhitelist() {
        return new NeoWhitelist(this.server.getPlayerList().getWhiteList());
    }

    @Override
    public void sendServerCommand(String command) {
        Commands manager = this.server.getCommands();
        CommandSourceStack source = this.server.createCommandSourceStack();
        manager.performPrefixedCommand(source, command);
    }

    @Override
    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        CommandDispatcher dispatcher = this.server.getCommands().getDispatcher();
        for (CommandNode node : dispatcher.getRoot().getChildren()) {
            commands.add(node.getName());
        }
        return commands;
    }

    @Override
    public HashMap<String, Object> getGamerules() {
        CompoundTag gamerulesNbt = this.server.getGameRules().createTag();
        HashMap<String, Object> gamerules = new HashMap<String, Object>();
        for (String key : gamerulesNbt.keySet()) {
            String valueStr = gamerulesNbt.getStringOr(key, "");
            if (valueStr.equals("true") || valueStr.equals("false")) {
                gamerules.put(key, Boolean.valueOf(valueStr));
                continue;
            }
            gamerules.put(key, Integer.valueOf(valueStr));
        }
        return gamerules;
    }

    @Override
    public void setGamerules(final HashMap<String, Object> gamerules) {
        final GameRules gameRulesObj = this.server.getGameRules();
        gameRulesObj.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                super.visit(key, type);
                gamerules.forEach((ruleName, value) -> {
                    if (value == null) {
                        return;
                    }
                    if (key.getId().equals(ruleName)) {
                        if (value instanceof Boolean) {
                            gameRulesObj.getRule(key).setFrom((GameRules.Value)new GameRules.BooleanValue(type, ((Boolean)value).booleanValue()), NeoServer.this.server);
                        } else if (value instanceof Number) {
                            gameRulesObj.getRule(key).setFrom((GameRules.Value)new GameRules.IntegerValue(type, Double.valueOf((Double)value).intValue()), NeoServer.this.server);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void reload() {
        this.sendServerCommand("reload");
    }

    @Override
    public void stop() {
        this.server.halt(false);
    }

    @Override
    public long getIngameTime() {
        return this.server.overworld().getDayTime();
    }
}

