/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.spigot_1_21.terminal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.opanel.terminal.ConsoleLog;
import net.opanel.terminal.LogListenerManager;
import net.opanel.utils.Utils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="LogListenerAppender", category="Core", elementType="appender")
public class LogListenerManagerImpl
extends AbstractAppender
implements LogListenerManager {
    private final List<ConsoleLog> logs = new ArrayList<ConsoleLog>();
    private final Set<Consumer<ConsoleLog>> listeners = new HashSet<Consumer<ConsoleLog>>();

    protected LogListenerManagerImpl(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public void append(LogEvent e) {
        if (e.getLevel() != Level.INFO && e.getLevel() != Level.WARN && e.getLevel() != Level.ERROR) {
            return;
        }
        long time = e.getTimeMillis();
        String level = e.getLevel().name();
        String thread = e.getThreadName();
        String source = e.getLoggerName();
        String line = e.getMessage().getFormattedMessage();
        ConsoleLog log = new ConsoleLog(time, level, thread, source, line);
        Throwable throwable = e.getThrown();
        if (throwable != null) {
            log.setThrownMessage(Utils.stringifyThrowable(throwable));
        }
        this.logs.add(log);
        this.listeners.forEach(listener -> listener.accept(log));
    }

    @PluginFactory
    public static LogListenerManagerImpl createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions) {
        PatternLayout pattern = PatternLayout.createDefaultLayout();
        return new LogListenerManagerImpl(name, null, (Layout<? extends Serializable>)pattern, ignoreExceptions, null);
    }

    @Override
    public void addListener(Consumer<ConsoleLog> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public List<ConsoleLog> getRecentLogs() {
        return this.logs;
    }
}

