/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.jndi.ContextFactory;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.jndi.local.localContextRoot;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.NamingDump;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(EnvConfiguration.class);
    private static final String JETTY_ENV_BINDINGS = "org.eclipse.jetty.jndi.EnvConfiguration";
    private Resource jettyEnvXmlResource;
    private NamingDump _dumper;

    public EnvConfiguration() {
        this.addDependencies(WebXmlConfiguration.class, MetaInfConfiguration.class, FragmentConfiguration.class);
        this.addDependents(PlusConfiguration.class, JettyWebXmlConfiguration.class);
        this.protectAndExpose("org.eclipse.jetty.jndi.");
    }

    public void setJettyEnvResource(Resource resource) {
        this.jettyEnvXmlResource = resource;
    }

    public void setJettyEnvXml(URL url) {
        this.jettyEnvXmlResource = Resource.newResource(url);
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this.createEnvContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(WebAppContext context) throws Exception {
        Resource jettyEnv;
        Resource webInf;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created java:comp/env for webapp {}", (Object)context.getContextPath());
        }
        if (this.jettyEnvXmlResource == null && (webInf = context.getWebInf()) != null && webInf.isDirectory() && (jettyEnv = webInf.addPath("jetty-env.xml")).exists()) {
            this.jettyEnvXmlResource = jettyEnv;
        }
        if (this.jettyEnvXmlResource != null) {
            NamingContext namingContext = localContextRoot.getRoot();
            synchronized (namingContext) {
                final ArrayList bindings = new ArrayList();
                NamingContext.Listener listener = new NamingContext.Listener(){

                    @Override
                    public void unbind(NamingContext ctx, Binding binding) {
                    }

                    @Override
                    public Binding bind(NamingContext ctx, Binding binding) {
                        bindings.add(new Bound(ctx, binding.getName()));
                        return binding;
                    }
                };
                try {
                    localContextRoot.getRoot().addListener(listener);
                    XmlConfiguration configuration = new XmlConfiguration(this.jettyEnvXmlResource);
                    configuration.setJettyStandardIdsAndProperties(context.getServer(), null);
                    WebAppClassLoader.runWithServerClassAccess(() -> {
                        configuration.configure(context);
                        return null;
                    });
                }
                finally {
                    localContextRoot.getRoot().removeListener(listener);
                    context.setAttribute(JETTY_ENV_BINDINGS, bindings);
                }
            }
        }
        this.bindEnvEntries(context);
        this._dumper = new NamingDump(context.getClassLoader(), "java:comp");
        context.addBean(this._dumper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        context.removeBean(this._dumper);
        this._dumper = null;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(context.getClassLoader());
        ContextFactory.associateClassLoader(context.getClassLoader());
        try {
            InitialContext ic = new InitialContext();
            Context compCtx = (Context)ic.lookup("java:comp");
            compCtx.destroySubcontext("env");
            List bindings = (List)context.getAttribute(JETTY_ENV_BINDINGS);
            context.setAttribute(JETTY_ENV_BINDINGS, null);
            if (bindings != null) {
                Collections.reverse(bindings);
                for (Bound b : bindings) {
                    b._context.destroySubcontext(b._name);
                }
            }
        }
        catch (NameNotFoundException e) {
            LOG.warn("Unable to destroy InitialContext", (Throwable)e);
        }
        finally {
            ContextFactory.disassociateClassLoader();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    @Override
    public void destroy(WebAppContext context) throws Exception {
        try {
            NamingContext scopeContext = (NamingContext)NamingEntryUtil.getContextForScope(context);
            scopeContext.getParent().destroySubcontext(scopeContext.getName());
        }
        catch (NameNotFoundException e) {
            LOG.trace("IGNORED", (Throwable)e);
            LOG.debug("No jndi entries scoped to webapp {}", (Object)context);
        }
        catch (NamingException e) {
            LOG.debug("Error unbinding jndi entries scoped to webapp {}", (Object)context, (Object)e);
        }
    }

    public void bindEnvEntries(WebAppContext context) throws NamingException {
        InitialContext ic = new InitialContext();
        Context envCtx = (Context)ic.lookup("java:comp/env");
        LOG.debug("Binding env entries from the jvm scope");
        this.doBindings(envCtx, null);
        LOG.debug("Binding env entries from the server scope");
        this.doBindings(envCtx, context.getServer());
        LOG.debug("Binding env entries from the context scope");
        this.doBindings(envCtx, context);
    }

    private void doBindings(Context envCtx, Object scope) throws NamingException {
        for (EnvEntry ee : NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class)) {
            ee.bindToENC(ee.getJndiName());
            Name namingEntryName = NamingEntryUtil.makeNamingEntryName(null, ee);
            NamingUtil.bind(envCtx, namingEntryName.toString(), ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createEnvContext(WebAppContext wac) throws NamingException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        ContextFactory.associateClassLoader(wac.getClassLoader());
        try {
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.createSubcontext("env");
        }
        finally {
            ContextFactory.disassociateClassLoader();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private static class Bound {
        final NamingContext _context;
        final String _name;

        Bound(NamingContext context, String name) {
            this._context = context;
            this._name = name;
        }
    }
}

