/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.utils.TPS;
import net.opanel.web.BaseServlet;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;

public class MonitorServlet
extends BaseServlet {
    public static final String route = "/api/monitor";

    public MonitorServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("cpu", this.getCpuRate());
        obj.put("mem", this.getMemRate());
        obj.put("tps", TPS.getRecentTPS());
        this.sendResponse(res, obj);
    }

    public double getCpuRate() {
        SystemInfo si = new SystemInfo();
        double load = si.getHardware().getProcessor().getSystemCpuLoad(500L) * 100.0;
        return Math.round(load);
    }

    public double getMemRate() {
        SystemInfo si = new SystemInfo();
        GlobalMemory gm = si.getHardware().getMemory();
        long total = gm.getTotal();
        long avail = gm.getAvailable();
        long used = total - avail;
        double rate = (double)used / (double)total * 100.0;
        return Math.round(rate);
    }
}

