/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import net.opanel.OPanel;
import net.opanel.common.OPanelServer;
import net.opanel.utils.Utils;
import net.opanel.web.BaseServlet;

public class IconServlet
extends BaseServlet {
    public static final String route = "/api/icon";
    private static final MultipartConfigElement multipartConfig = new MultipartConfigElement(OPanel.TMP_DIR_PATH.toString(), -1L, -1L, 0x100000);

    public IconServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        OPanelServer server = this.plugin.getServer();
        byte[] favicon = server.getFavicon();
        if (favicon == null) {
            this.sendResponse(res, 404);
            return;
        }
        this.sendContentResponse(res, favicon, "image/png");
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        OPanelServer server = this.plugin.getServer();
        req.setCharacterEncoding("utf-8");
        req.setAttribute("org.eclipse.jetty.multipartConfig", multipartConfig);
        try {
            Part filePart = req.getPart("file");
            if (filePart == null || filePart.getSize() <= 0L) {
                this.sendResponse(res, 400);
                return;
            }
            if (!filePart.getSubmittedFileName().endsWith(".png")) {
                this.sendResponse(res, 400);
                return;
            }
            try (InputStream is = filePart.getInputStream();){
                byte[] iconBytes = is.readAllBytes();
                int[] dimensions = Utils.getImageDimensions(iconBytes);
                if (dimensions[0] != 64 || dimensions[1] != 64) {
                    this.sendResponse(res, 400);
                    return;
                }
                server.setFavicon(iconBytes);
                this.sendResponse(res, 200);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendResponse(res, 500);
        }
    }
}

