/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtility {
    private static final int BUFFER_SIZE = 8192;

    public static void zip(Path sourceDirPath, Path zipPath) throws IOException {
        File sourceDir = new File(sourceDirPath.toString());
        if (!sourceDir.exists()) {
            throw new IOException("Cannot find the source directory.");
        }
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipPath.toString()));){
            ZipUtility.addFolderToZos(sourceDir, sourceDir.getName(), zos);
        }
    }

    private static void addFolderToZos(File folder, String parentDirName, ZipOutputStream zos) throws IOException {
        if (!folder.exists()) {
            throw new IOException("Folder not found: " + folder.getPath());
        }
        for (File item : folder.listFiles()) {
            if (item.getName().endsWith("session.lock")) continue;
            if (item.isDirectory()) {
                ZipUtility.addFolderToZos(item, parentDirName + "/" + item.getName(), zos);
                continue;
            }
            String entryName = parentDirName + "/" + item.getName();
            ZipEntry entry = new ZipEntry(entryName);
            zos.putNextEntry(entry);
            try (FileInputStream fis = new FileInputStream(item);){
                int read;
                byte[] bytesIn = new byte[8192];
                while ((read = fis.read(bytesIn)) != -1) {
                    zos.write(bytesIn, 0, read);
                }
            }
            zos.closeEntry();
        }
    }

    public static void unzip(Path zipPath, Path targetDirPath) throws IOException, ZipException {
        File targetDir = new File(targetDirPath.toString());
        if (!targetDir.exists() && !targetDir.mkdir()) {
            throw new IOException("Cannot create target directory.");
        }
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(zipPath.toString()));){
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                Path filePath = targetDirPath.resolve(entry.getName());
                if (!filePath.normalize().startsWith(targetDirPath.normalize())) {
                    targetDir.delete();
                    throw new ZipException("Zip slip detected.");
                }
                if (!entry.isDirectory()) {
                    File parentDir = new File(filePath.toString()).getParentFile();
                    if (!parentDir.exists() && !parentDir.mkdir()) {
                        throw new IOException("Cannot create directory '" + parentDir.getName() + "'.");
                    }
                    try (FileOutputStream fos = new FileOutputStream(filePath.toString());){
                        int read;
                        byte[] bytesIn = new byte[8192];
                        while ((read = zin.read(bytesIn)) != -1) {
                            fos.write(bytesIn, 0, read);
                        }
                    }
                } else {
                    File dir = new File(filePath.toString());
                    if (!dir.mkdir()) {
                        throw new IOException("Cannot create directory '" + entry.getName() + "'.");
                    }
                }
                zin.closeEntry();
                entry = zin.getNextEntry();
            }
        }
    }
}

