/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.utils.Utils;
import net.opanel.web.BaseServlet;
import net.opanel.web.JwtManager;

public class AuthServlet
extends BaseServlet {
    public static final String route = "/api/auth";
    private final HashMap<String, String> cramMap = new HashMap();
    private static final int maxTries = 5;
    private static final long bannedPeriod = 600000L;
    private final HashMap<String, Integer> failedRecords = new HashMap();
    private final HashMap<String, Long> temporaryBannedRecords = new HashMap();

    public AuthServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String id = req.getParameter("id");
        if (id == null) {
            this.sendResponse(res, 400);
            return;
        }
        String remoteHost = req.getRemoteHost();
        if (System.currentTimeMillis() < this.temporaryBannedRecords.getOrDefault(remoteHost, 0L)) {
            this.sendResponse(res, 403);
            return;
        }
        if (this.failedRecords.getOrDefault(remoteHost, 0) >= 5) {
            this.temporaryBannedRecords.put(remoteHost, System.currentTimeMillis() + 600000L);
            this.failedRecords.put(remoteHost, 0);
            this.sendResponse(res, 403);
            return;
        }
        if (this.temporaryBannedRecords.containsKey(remoteHost) && System.currentTimeMillis() >= this.temporaryBannedRecords.get(remoteHost)) {
            this.temporaryBannedRecords.remove(remoteHost);
        }
        String cramRandomHex = Utils.generateRandomHex(16);
        while (this.cramMap.containsValue(cramRandomHex)) {
            cramRandomHex = Utils.generateRandomHex(16);
        }
        this.cramMap.put(id, cramRandomHex);
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("cram", cramRandomHex);
        this.sendResponse(res, obj);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        RequestBodyType reqBody = this.getRequestBody(req, RequestBodyType.class);
        if (reqBody.id == null || reqBody.result == null) {
            this.sendResponse(res, 400);
            return;
        }
        String remoteHost = req.getRemoteHost();
        int remotePort = req.getRemotePort();
        String challengeResult = reqBody.result;
        String storedRealKey = this.plugin.getConfig().accessKey;
        String realResult = Utils.md5(storedRealKey + this.cramMap.get(reqBody.id));
        this.cramMap.remove(reqBody.id);
        if (challengeResult.equals(realResult)) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("token", JwtManager.generateToken(storedRealKey, this.plugin.getConfig().salt));
            this.failedRecords.remove(remoteHost);
            this.sendResponse(res, obj);
        } else {
            int current = this.failedRecords.getOrDefault(remoteHost, 0);
            this.failedRecords.put(remoteHost, current + 1);
            if (current + 1 >= 5) {
                this.temporaryBannedRecords.put(remoteHost, System.currentTimeMillis() + 600000L);
                this.failedRecords.put(remoteHost, 0);
            }
            this.plugin.logger.warn("A failed login request from " + remoteHost + ":" + remotePort + " (Failed for " + (current + 1) + " times)");
            this.sendResponse(res, 401);
        }
    }

    private class RequestBodyType {
        String id;
        String result;

        private RequestBodyType() {
        }
    }
}

