/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.common.features;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.stream.Stream;
import net.opanel.utils.Utils;

public interface CodeOfConductFeature {
    public static final Path codeOfConductPath = Paths.get("", new String[0]).resolve("codeofconduct");

    default public HashMap<String, String> getCodeOfConducts() throws IOException {
        HashMap<String, String> list = new HashMap<String, String>();
        if (!Files.exists(codeOfConductPath, new LinkOption[0])) {
            Files.createDirectory(codeOfConductPath, new FileAttribute[0]);
        }
        try (Stream<Path> stream = Files.list(codeOfConductPath);){
            stream.filter(item -> !Files.isDirectory(item, new LinkOption[0]) && item.toString().endsWith(".txt") && Utils.validateLocaleCode(item.getFileName().toString().replace(".txt", ""))).forEach(item -> {
                try {
                    String lang = item.getFileName().toString().replace(".txt", "");
                    String content = Utils.readTextFile(item);
                    list.put(lang, content);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        return list;
    }

    default public void updateOrCreateCodeOfConduct(String lang, String content) throws IOException {
        Path filePath = codeOfConductPath.resolve(lang + ".txt");
        if (!Files.exists(filePath, new LinkOption[0])) {
            Files.createFile(filePath, new FileAttribute[0]);
        }
        Utils.writeTextFile(filePath, content);
    }

    default public void removeCodeOfConduct(String lang) throws IOException {
        Path filePath = codeOfConductPath.resolve(lang + ".txt");
        Files.deleteIfExists(filePath);
    }
}

