/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_1_21_9;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11560;
import net.minecraft.class_11755;
import net.minecraft.class_1934;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3335;
import net.minecraft.class_3336;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;

public class FabricOfflinePlayer
implements OPanelPlayer {
    private final class_3324 playerManager;
    private final Path playerDataPath;
    private final GameProfile profile;
    private final UUID uuid;

    public FabricOfflinePlayer(MinecraftServer server, UUID uuid) {
        this.playerManager = server.method_3760();
        this.playerDataPath = server.method_27050(class_5218.field_24182).resolve(String.valueOf(uuid) + ".dat");
        class_11755 profileCache = server.method_73550().comp_4624();
        this.uuid = uuid;
        if (!Files.exists(this.playerDataPath, new LinkOption[0])) {
            throw new NullPointerException("Player data file for UUID " + String.valueOf(uuid) + " unavailable.");
        }
        class_3222 serverPlayer = this.playerManager.method_14602(uuid);
        if (serverPlayer != null && !serverPlayer.method_14239()) {
            throw new IllegalStateException("The provided player is online, please use FabricPlayer class instead.");
        }
        Optional profileOpt = profileCache.method_73290(uuid);
        if (profileOpt.isEmpty()) {
            throw new NullPointerException("Cannot get the game profile of the provided player.");
        }
        this.profile = (GameProfile)profileOpt.get();
    }

    @Override
    public String getName() {
        return this.profile.name();
    }

    @Override
    public String getUUID() {
        return this.uuid.toString();
    }

    @Override
    public boolean isOnline() {
        return false;
    }

    @Override
    public boolean isOp() {
        return this.playerManager.method_14569(new class_11560(this.profile));
    }

    @Override
    public boolean isBanned() {
        return this.playerManager.method_14563().method_14650(new class_11560(this.profile));
    }

    @Override
    public OPanelGameMode getGameMode() {
        try {
            class_2487 nbt = class_2507.method_30613((Path)this.playerDataPath, (class_2505)class_2505.method_53899((long)0x200000L));
            int gamemodeId = nbt.method_68083("playerGameType", 0);
            class_1934 gamemode = class_1934.method_8384((int)gamemodeId);
            switch (gamemode) {
                case field_9216: {
                    return OPanelGameMode.ADVENTURE;
                }
                case field_9215: {
                    return OPanelGameMode.SURVIVAL;
                }
                case field_9220: {
                    return OPanelGameMode.CREATIVE;
                }
                case field_9219: {
                    return OPanelGameMode.SPECTATOR;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        try {
            class_2487 nbt = class_2507.method_30613((Path)this.playerDataPath, (class_2505)class_2505.method_53899((long)0x200000L));
            switch (gamemode) {
                case ADVENTURE: {
                    nbt.method_10569("playerGameType", 2);
                    break;
                }
                case SURVIVAL: {
                    nbt.method_10569("playerGameType", 0);
                    break;
                }
                case CREATIVE: {
                    nbt.method_10569("playerGameType", 1);
                    break;
                }
                case SPECTATOR: {
                    nbt.method_10569("playerGameType", 3);
                }
            }
            class_2507.method_30614((class_2487)nbt, (Path)this.playerDataPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.playerManager.method_14582(new class_11560(this.profile));
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.playerManager.method_14604(new class_11560(this.profile));
    }

    @Override
    public void kick(String reason) {
        throw new IllegalStateException("The player is offline.");
    }

    @Override
    public void ban(String reason) {
        if (this.isBanned()) {
            return;
        }
        class_3335 bannedList = this.playerManager.method_14563();
        class_3336 entry = new class_3336(new class_11560(this.profile), new Date(), null, null, reason);
        bannedList.method_74006(entry);
    }

    @Override
    public String getBanReason() {
        if (!this.isBanned()) {
            return null;
        }
        class_3336 banEntry = (class_3336)this.playerManager.method_14563().method_14640((Object)new class_11560(this.profile));
        if (banEntry == null) {
            return null;
        }
        return banEntry.method_14503();
    }

    @Override
    public void pardon() {
        if (!this.isBanned()) {
            return;
        }
        this.playerManager.method_14563().method_74007(new class_11560(this.profile));
    }

    @Override
    public int getPing() {
        throw new IllegalStateException("The player is offline.");
    }
}

