/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.deps.oshi.hardware.platform.mac;

import java.util.List;
import net.opanel.deps.oshi.annotation.concurrent.ThreadSafe;
import net.opanel.deps.oshi.hardware.CentralProcessor;
import net.opanel.deps.oshi.hardware.ComputerSystem;
import net.opanel.deps.oshi.hardware.Display;
import net.opanel.deps.oshi.hardware.GlobalMemory;
import net.opanel.deps.oshi.hardware.GraphicsCard;
import net.opanel.deps.oshi.hardware.HWDiskStore;
import net.opanel.deps.oshi.hardware.LogicalVolumeGroup;
import net.opanel.deps.oshi.hardware.NetworkIF;
import net.opanel.deps.oshi.hardware.PowerSource;
import net.opanel.deps.oshi.hardware.Sensors;
import net.opanel.deps.oshi.hardware.SoundCard;
import net.opanel.deps.oshi.hardware.UsbDevice;
import net.opanel.deps.oshi.hardware.common.AbstractHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.mac.MacCentralProcessor;
import net.opanel.deps.oshi.hardware.platform.mac.MacComputerSystem;
import net.opanel.deps.oshi.hardware.platform.mac.MacDisplay;
import net.opanel.deps.oshi.hardware.platform.mac.MacGlobalMemory;
import net.opanel.deps.oshi.hardware.platform.mac.MacGraphicsCard;
import net.opanel.deps.oshi.hardware.platform.mac.MacHWDiskStore;
import net.opanel.deps.oshi.hardware.platform.mac.MacLogicalVolumeGroup;
import net.opanel.deps.oshi.hardware.platform.mac.MacNetworkIF;
import net.opanel.deps.oshi.hardware.platform.mac.MacPowerSource;
import net.opanel.deps.oshi.hardware.platform.mac.MacSensors;
import net.opanel.deps.oshi.hardware.platform.mac.MacSoundCard;
import net.opanel.deps.oshi.hardware.platform.mac.MacUsbDevice;

@ThreadSafe
public final class MacHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    @Override
    public ComputerSystem createComputerSystem() {
        return new MacComputerSystem();
    }

    @Override
    public GlobalMemory createMemory() {
        return new MacGlobalMemory();
    }

    @Override
    public CentralProcessor createProcessor() {
        return new MacCentralProcessor();
    }

    @Override
    public Sensors createSensors() {
        return new MacSensors();
    }

    @Override
    public List<PowerSource> getPowerSources() {
        return MacPowerSource.getPowerSources();
    }

    @Override
    public List<HWDiskStore> getDiskStores() {
        return MacHWDiskStore.getDisks();
    }

    @Override
    public List<LogicalVolumeGroup> getLogicalVolumeGroups() {
        return MacLogicalVolumeGroup.getLogicalVolumeGroups();
    }

    @Override
    public List<Display> getDisplays() {
        return MacDisplay.getDisplays();
    }

    @Override
    public List<NetworkIF> getNetworkIFs(boolean includeLocalInterfaces) {
        return MacNetworkIF.getNetworks(includeLocalInterfaces);
    }

    @Override
    public List<UsbDevice> getUsbDevices(boolean tree) {
        return MacUsbDevice.getUsbDevices(tree);
    }

    @Override
    public List<SoundCard> getSoundCards() {
        return MacSoundCard.getSoundCards();
    }

    @Override
    public List<GraphicsCard> getGraphicsCards() {
        return MacGraphicsCard.getGraphicsCards();
    }
}

