/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.opanel.OPanel;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.utils.TPS;
import net.opanel.utils.Utils;
import net.opanel.web.BaseController;

public class InfoController
extends BaseController {
    public Handler getServerInfo = ctx -> {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("favicon", this.server.getFavicon() != null ? "/api/icon?t=" + System.currentTimeMillis() : null);
        obj.put("motd", Utils.stringToBase64(this.server.getMotd()));
        obj.put("port", this.server.getPort());
        obj.put("maxPlayerCount", this.server.getMaxPlayerCount());
        obj.put("whitelist", this.server.isWhitelistEnabled());
        obj.put("uptime", this.plugin.getUptimer().getCurrent());
        HashMap<String, Object> ingameTimeObj = new HashMap<String, Object>();
        ingameTimeObj.put("current", this.server.getIngameTime());
        ingameTimeObj.put("doDaylightCycle", this.server.getGamerules().get("doDaylightCycle"));
        ingameTimeObj.put("paused", TPS.isPaused());
        ingameTimeObj.put("mspt", TPS.getRecentMSPT());
        obj.put("ingameTime", ingameTimeObj);
        List players = this.server.getOnlinePlayers().stream().map(player -> {
            HashMap<String, Object> playerInfo = new HashMap<String, Object>();
            playerInfo.put("name", player.getName());
            playerInfo.put("uuid", player.getUUID());
            playerInfo.put("gamemode", player.getGameMode().getName());
            playerInfo.put("ping", player.getPing());
            return playerInfo;
        }).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        obj.put("onlinePlayers", players);
        this.sendResponse(ctx, obj);
    };
    public Handler setMotd = ctx -> {
        try {
            String motd = ctx.bodyAsClass(String.class);
            if (motd.isEmpty() || motd.trim().isEmpty()) {
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Motd is missing.");
                return;
            }
            this.server.setMotd(Utils.base64ToString(motd));
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IOException e) {
            this.plugin.logger.error("Failed to update motd: " + e.getMessage());
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.plugin.logger.error("Invalid Base64 encoding in motd: " + e.getMessage());
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Invalid Base64 encoding in motd.");
        }
    };

    public InfoController(OPanel plugin) {
        super(plugin);
    }
}

