/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.lang;

import io.jsonwebtoken.lang.InstantiationException;
import io.jsonwebtoken.lang.UnknownClassException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public final class Classes {
    private static final ClassLoaderAccessor THREAD_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final ClassLoaderAccessor CLASS_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() {
            return Classes.class.getClassLoader();
        }
    };
    private static final ClassLoaderAccessor SYSTEM_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() {
            return ClassLoader.getSystemClassLoader();
        }
    };

    private Classes() {
    }

    public static <T> Class<T> forName(String fqcn) throws UnknownClassException {
        Class<?> clazz = THREAD_CL_ACCESSOR.loadClass(fqcn);
        if (clazz == null) {
            clazz = CLASS_CL_ACCESSOR.loadClass(fqcn);
        }
        if (clazz == null) {
            clazz = SYSTEM_CL_ACCESSOR.loadClass(fqcn);
        }
        if (clazz == null) {
            String msg = "Unable to load class named [" + fqcn + "] from the thread context, current, or " + "system/application ClassLoaders.  All heuristics have been exhausted.  Class could not be found.";
            if (fqcn != null && fqcn.startsWith("io.jsonwebtoken.impl")) {
                msg = msg + "  Have you remembered to include the jjwt-impl.jar in your runtime classpath?";
            }
            throw new UnknownClassException(msg);
        }
        return clazz;
    }

    public static InputStream getResourceAsStream(String name) {
        InputStream is = THREAD_CL_ACCESSOR.getResourceStream(name);
        if (is == null) {
            is = CLASS_CL_ACCESSOR.getResourceStream(name);
        }
        if (is == null) {
            is = SYSTEM_CL_ACCESSOR.getResourceStream(name);
        }
        return is;
    }

    private static URL getResource(String name) {
        URL url2 = THREAD_CL_ACCESSOR.getResource(name);
        if (url2 == null) {
            url2 = CLASS_CL_ACCESSOR.getResource(name);
        }
        if (url2 == null) {
            return SYSTEM_CL_ACCESSOR.getResource(name);
        }
        return url2;
    }

    public static boolean isAvailable(String fullyQualifiedClassName) {
        try {
            Classes.forName(fullyQualifiedClassName);
            return true;
        }
        catch (UnknownClassException e) {
            return false;
        }
    }

    public static <T> T newInstance(String fqcn) {
        return Classes.newInstance(Classes.forName(fqcn));
    }

    public static <T> T newInstance(String fqcn, Class<?>[] ctorArgTypes, Object ... args2) {
        Class<T> clazz = Classes.forName(fqcn);
        Constructor<T> ctor = Classes.getConstructor(clazz, ctorArgTypes);
        return Classes.instantiate(ctor, args2);
    }

    public static <T> T newInstance(String fqcn, Object ... args2) {
        return Classes.newInstance(Classes.forName(fqcn), args2);
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (clazz == null) {
            String msg = "Class method parameter cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new InstantiationException("Unable to instantiate class [" + clazz.getName() + "]", e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args2) {
        Class[] argTypes = new Class[args2.length];
        for (int i = 0; i < args2.length; ++i) {
            argTypes[i] = args2[i].getClass();
        }
        Constructor<T> ctor = Classes.getConstructor(clazz, argTypes);
        return Classes.instantiate(ctor, args2);
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... argTypes) throws IllegalStateException {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T instantiate(Constructor<T> ctor, Object ... args2) {
        try {
            return ctor.newInstance(args2);
        }
        catch (Exception e) {
            String msg = "Unable to instantiate instance with constructor [" + ctor + "]";
            throw new InstantiationException(msg, e);
        }
    }

    public static <T> T invokeStatic(String fqcn, String methodName, Class<?>[] argTypes, Object ... args2) {
        try {
            Class<T> clazz = Classes.forName(fqcn);
            return Classes.invokeStatic(clazz, methodName, argTypes, args2);
        }
        catch (Exception e) {
            String msg = "Unable to invoke class method " + fqcn + "#" + methodName + ".  Ensure the necessary " + "implementation is in the runtime classpath.";
            throw new IllegalStateException(msg, e);
        }
    }

    public static <T> T invokeStatic(Class<?> clazz, String methodName, Class<?>[] argTypes, Object ... args2) {
        try {
            Method method2 = clazz.getDeclaredMethod(methodName, argTypes);
            method2.setAccessible(true);
            return (T)method2.invoke(null, args2);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            String msg = "Unable to invoke class method " + clazz.getName() + "#" + methodName + ". Ensure the necessary implementation is in the runtime classpath.";
            throw new IllegalStateException(msg, e);
        }
    }

    public static <T> T getFieldValue(Object instance, String fieldName, Class<T> fieldType) {
        if (instance == null) {
            return null;
        }
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object o = field.get(instance);
            return fieldType.cast(o);
        }
        catch (Throwable t) {
            String msg = "Unable to read field " + instance.getClass().getName() + "#" + fieldName + ": " + t.getMessage();
            throw new IllegalStateException(msg, t);
        }
    }

    private static abstract class ExceptionIgnoringAccessor
    implements ClassLoaderAccessor {
        private ExceptionIgnoringAccessor() {
        }

        @Override
        public Class<?> loadClass(String fqcn) {
            Class<?> clazz = null;
            ClassLoader cl = this.getClassLoader();
            if (cl != null) {
                try {
                    clazz = cl.loadClass(fqcn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return clazz;
        }

        @Override
        public URL getResource(String name) {
            URL url2 = null;
            ClassLoader cl = this.getClassLoader();
            if (cl != null) {
                url2 = cl.getResource(name);
            }
            return url2;
        }

        @Override
        public InputStream getResourceStream(String name) {
            InputStream is = null;
            ClassLoader cl = this.getClassLoader();
            if (cl != null) {
                is = cl.getResourceAsStream(name);
            }
            return is;
        }

        protected final ClassLoader getClassLoader() {
            try {
                return this.doGetClassLoader();
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        protected abstract ClassLoader doGetClassLoader() throws Throwable;
    }

    private static interface ClassLoaderAccessor {
        public Class<?> loadClass(String var1);

        public URL getResource(String var1);

        public InputStream getResourceStream(String var1);
    }
}

