/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.web;

import net.opanel.OPanel;
import net.opanel.deps.javalin.http.ContentType;
import net.opanel.deps.javalin.http.Context;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HandlerType;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.deps.javalin.http.servlet.JavalinServletContext;
import net.opanel.web.BaseController;
import net.opanel.web.JwtManager;

public class BeforeController
extends BaseController {
    private static final String DEFAULT_RSC_FILE = "index.txt";
    public Handler beforeAll = ctx -> ctx.header("X-Powered-By", "OPanel");
    public Handler authCookie = ctx -> {
        if (ctx.path().equals("/api/auth") || ctx.path().equals("/api/icon") || ctx.method() == HandlerType.OPTIONS) {
            return;
        }
        String token = ctx.header("X-Credential-Token");
        if (token == null) {
            this.sendResponse(ctx, HttpStatus.UNAUTHORIZED, "Token is missing.");
            this.clearContextTasks(ctx);
            return;
        }
        String hashedRealKey = this.plugin.getConfig().accessKey;
        if (!JwtManager.verifyToken(token, hashedRealKey, this.plugin.getConfig().salt)) {
            this.sendResponse(ctx, HttpStatus.UNAUTHORIZED, "Token is invalid.");
            this.clearContextTasks(ctx);
        }
    };
    public Handler handleRsc = ctx -> {
        String reqPath = ctx.path();
        if (reqPath.contains(".txt") && ctx.queryParam("_rsc") != null && !reqPath.contains(DEFAULT_RSC_FILE)) {
            String transformedPath = ctx.fullUrl().replace(".txt", "/index.txt");
            ctx.redirect(transformedPath);
        }
    };
    public Handler handleFonts = ctx -> {
        if (ctx.path().endsWith(".ttf")) {
            ctx.status(HttpStatus.OK);
            ctx.contentType(ContentType.FONT_TTF);
        }
        if (ctx.path().endsWith(".otf")) {
            ctx.status(HttpStatus.OK);
            ctx.contentType(ContentType.FONT_OTF);
        }
    };

    public BeforeController(OPanel plugin) {
        super(plugin);
    }

    private void clearContextTasks(Context ctx) {
        ((JavalinServletContext)ctx).getTasks().clear();
    }
}

