/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.security.Jwks;
import io.jsonwebtoken.security.KeyOperation;

final class KeyOperationConverter
implements Converter<KeyOperation, Object> {
    static final Converter<KeyOperation, Object> DEFAULT = new KeyOperationConverter(Jwks.OP.get());
    private final Registry<String, KeyOperation> registry;

    KeyOperationConverter(Registry<String, KeyOperation> registry) {
        this.registry = Assert.notEmpty(registry, "KeyOperation registry cannot be null or empty.");
    }

    @Override
    public String applyTo(KeyOperation operation) {
        Assert.notNull(operation, "KeyOperation cannot be null.");
        return operation.getId();
    }

    @Override
    public KeyOperation applyFrom(Object o) {
        if (o instanceof KeyOperation) {
            return (KeyOperation)o;
        }
        String id = Assert.isInstanceOf(String.class, o, "Argument must be a KeyOperation or String.");
        Assert.hasText(id, "KeyOperation string value cannot be null or empty.");
        KeyOperation keyOp = (KeyOperation)this.registry.get(id);
        return keyOp != null ? keyOp : (KeyOperation)Jwks.OP.builder().id(id).build();
    }
}

