/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.opanel.event.EventType;
import net.opanel.event.OPanelEvent;

public class EventManager {
    private static EventManager instance;
    private final HashMap<EventType, Set<Consumer<? extends OPanelEvent>>> listenerMap = new HashMap();

    private EventManager() {
    }

    public <E extends OPanelEvent> void on(EventType type, Consumer<E> listener) {
        Set listeners = this.listenerMap.computeIfAbsent(type, k -> new HashSet());
        listeners.add(listener);
    }

    public <E extends OPanelEvent> void emit(EventType type, E event) {
        if (!this.listenerMap.containsKey((Object)type)) {
            return;
        }
        for (Consumer<? extends OPanelEvent> listeners : this.listenerMap.get((Object)type)) {
            listeners.accept(event);
        }
    }

    public static EventManager get() {
        if (instance == null) {
            instance = new EventManager();
        }
        return instance;
    }
}

