/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.deps.oshi.hardware.platform.linux;

import java.util.List;
import net.opanel.deps.oshi.annotation.concurrent.ThreadSafe;
import net.opanel.deps.oshi.hardware.CentralProcessor;
import net.opanel.deps.oshi.hardware.ComputerSystem;
import net.opanel.deps.oshi.hardware.Display;
import net.opanel.deps.oshi.hardware.GlobalMemory;
import net.opanel.deps.oshi.hardware.GraphicsCard;
import net.opanel.deps.oshi.hardware.HWDiskStore;
import net.opanel.deps.oshi.hardware.LogicalVolumeGroup;
import net.opanel.deps.oshi.hardware.NetworkIF;
import net.opanel.deps.oshi.hardware.PowerSource;
import net.opanel.deps.oshi.hardware.Sensors;
import net.opanel.deps.oshi.hardware.SoundCard;
import net.opanel.deps.oshi.hardware.UsbDevice;
import net.opanel.deps.oshi.hardware.common.AbstractHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxCentralProcessor;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxComputerSystem;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxGlobalMemory;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxGraphicsCard;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxHWDiskStore;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxLogicalVolumeGroup;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxNetworkIF;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxPowerSource;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxSensors;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxSoundCard;
import net.opanel.deps.oshi.hardware.platform.linux.LinuxUsbDevice;
import net.opanel.deps.oshi.hardware.platform.unix.UnixDisplay;

@ThreadSafe
public final class LinuxHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    @Override
    public ComputerSystem createComputerSystem() {
        return new LinuxComputerSystem();
    }

    @Override
    public GlobalMemory createMemory() {
        return new LinuxGlobalMemory();
    }

    @Override
    public CentralProcessor createProcessor() {
        return new LinuxCentralProcessor();
    }

    @Override
    public Sensors createSensors() {
        return new LinuxSensors();
    }

    @Override
    public List<PowerSource> getPowerSources() {
        return LinuxPowerSource.getPowerSources();
    }

    @Override
    public List<HWDiskStore> getDiskStores() {
        return LinuxHWDiskStore.getDisks();
    }

    @Override
    public List<LogicalVolumeGroup> getLogicalVolumeGroups() {
        return LinuxLogicalVolumeGroup.getLogicalVolumeGroups();
    }

    @Override
    public List<Display> getDisplays() {
        return UnixDisplay.getDisplays();
    }

    @Override
    public List<NetworkIF> getNetworkIFs(boolean includeLocalInterfaces) {
        return LinuxNetworkIF.getNetworks(includeLocalInterfaces);
    }

    @Override
    public List<UsbDevice> getUsbDevices(boolean tree) {
        return LinuxUsbDevice.getUsbDevices(tree);
    }

    @Override
    public List<SoundCard> getSoundCards() {
        return LinuxSoundCard.getSoundCards();
    }

    @Override
    public List<GraphicsCard> getGraphicsCards() {
        return LinuxGraphicsCard.getGraphicsCards();
    }
}

