/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.deps.oshi.hardware.platform.unix.solaris;

import java.util.function.Supplier;
import net.opanel.deps.oshi.annotation.concurrent.ThreadSafe;
import net.opanel.deps.oshi.driver.unix.solaris.kstat.SystemPages;
import net.opanel.deps.oshi.hardware.VirtualMemory;
import net.opanel.deps.oshi.hardware.common.AbstractGlobalMemory;
import net.opanel.deps.oshi.hardware.platform.unix.solaris.SolarisVirtualMemory;
import net.opanel.deps.oshi.util.ExecutingCommand;
import net.opanel.deps.oshi.util.Memoizer;
import net.opanel.deps.oshi.util.ParseUtil;
import net.opanel.deps.oshi.util.tuples.Pair;

@ThreadSafe
final class SolarisGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Pair<Long, Long>> availTotal = Memoizer.memoize(SystemPages::queryAvailableTotal, Memoizer.defaultExpiration());
    private final Supplier<Long> pageSize = Memoizer.memoize(SolarisGlobalMemory::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    SolarisGlobalMemory() {
    }

    @Override
    public long getAvailable() {
        return this.availTotal.get().getA() * this.getPageSize();
    }

    @Override
    public long getTotal() {
        return this.availTotal.get().getB() * this.getPageSize();
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private static long queryPageSize() {
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("pagesize"), 4096L);
    }

    private VirtualMemory createVirtualMemory() {
        return new SolarisVirtualMemory(this);
    }
}

