/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.folia_1_20;

import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import net.opanel.folia_1_20.Main;
import org.bukkit.BanList;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FoliaPlayer
implements OPanelPlayer {
    private final Main plugin;
    private final Player player;

    public FoliaPlayer(Main plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public String getUUID() {
        return this.player.getUniqueId().toString();
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public boolean isOp() {
        return this.player.isOp();
    }

    @Override
    public boolean isBanned() {
        return false;
    }

    @Override
    public OPanelGameMode getGameMode() {
        GameMode gamemode = this.player.getGameMode();
        switch (gamemode) {
            case ADVENTURE: {
                return OPanelGameMode.ADVENTURE;
            }
            case SURVIVAL: {
                return OPanelGameMode.SURVIVAL;
            }
            case CREATIVE: {
                return OPanelGameMode.CREATIVE;
            }
            case SPECTATOR: {
                return OPanelGameMode.SPECTATOR;
            }
        }
        return null;
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        this.player.getScheduler().run((Plugin)this.plugin, task -> {
            switch (gamemode) {
                case ADVENTURE: {
                    this.player.setGameMode(GameMode.ADVENTURE);
                    break;
                }
                case SURVIVAL: {
                    this.player.setGameMode(GameMode.SURVIVAL);
                    break;
                }
                case CREATIVE: {
                    this.player.setGameMode(GameMode.CREATIVE);
                    break;
                }
                case SPECTATOR: {
                    this.player.setGameMode(GameMode.SPECTATOR);
                }
            }
        }, null);
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.player.getScheduler().run((Plugin)this.plugin, task -> this.player.setOp(true), null);
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.player.getScheduler().run((Plugin)this.plugin, task -> this.player.setOp(false), null);
    }

    @Override
    public void kick(String reason) {
        this.player.getScheduler().run((Plugin)this.plugin, task -> this.player.kickPlayer(reason), null);
    }

    @Override
    public void ban(String reason) {
        if (this.isBanned()) {
            return;
        }
        this.player.getScheduler().run((Plugin)this.plugin, task -> {
            this.player.getServer().getBanList(BanList.Type.NAME).addBan(this.player.getName(), reason, null, null);
            this.player.kickPlayer(reason);
        }, null);
    }

    @Override
    public String getBanReason() {
        return null;
    }

    @Override
    public void pardon() {
    }

    @Override
    public int getPing() {
        return this.player.getPing();
    }
}

