/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ClaimsBuilder;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.CompressionCodecResolver;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.Jwe;
import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtHandler;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.MissingClaimException;
import io.jsonwebtoken.PrematureJwtException;
import io.jsonwebtoken.ProtectedHeader;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.CompressionCodecLocator;
import io.jsonwebtoken.impl.DefaultClaims;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.DefaultJwe;
import io.jsonwebtoken.impl.DefaultJweHeader;
import io.jsonwebtoken.impl.DefaultJws;
import io.jsonwebtoken.impl.DefaultJwsHeader;
import io.jsonwebtoken.impl.DefaultJwt;
import io.jsonwebtoken.impl.DefaultProtectedHeader;
import io.jsonwebtoken.impl.IdLocator;
import io.jsonwebtoken.impl.JwtTokenizer;
import io.jsonwebtoken.impl.Payload;
import io.jsonwebtoken.impl.TokenizedJwe;
import io.jsonwebtoken.impl.TokenizedJwt;
import io.jsonwebtoken.impl.io.AbstractParser;
import io.jsonwebtoken.impl.io.BytesInputStream;
import io.jsonwebtoken.impl.io.CharSequenceReader;
import io.jsonwebtoken.impl.io.JsonObjectDeserializer;
import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.io.UncloseableInputStream;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.security.DefaultDecryptAeadRequest;
import io.jsonwebtoken.impl.security.DefaultDecryptionKeyRequest;
import io.jsonwebtoken.impl.security.DefaultVerifySecureDigestRequest;
import io.jsonwebtoken.impl.security.LocatingKeyResolver;
import io.jsonwebtoken.impl.security.ProviderKey;
import io.jsonwebtoken.io.CompressionAlgorithm;
import io.jsonwebtoken.io.Decoder;
import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.DateFormats;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.AeadAlgorithm;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeyAlgorithm;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.WeakKeyException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;

public class DefaultJwtParser
extends AbstractParser<Jwt<?, ?>>
implements JwtParser {
    static final char SEPARATOR_CHAR = '.';
    private static final JwtTokenizer jwtTokenizer = new JwtTokenizer();
    static final String PRIV_KEY_VERIFY_MSG = "PrivateKeys may not be used to verify digital signatures. PrivateKeys are used to sign, and PublicKeys are used to verify.";
    static final String PUB_KEY_DECRYPT_MSG = "PublicKeys may not be used to decrypt data. PublicKeys are used to encrypt, and PrivateKeys are used to decrypt.";
    public static final String INCORRECT_EXPECTED_CLAIM_MESSAGE_TEMPLATE = "Expected %s claim to be: %s, but was: %s.";
    public static final String MISSING_EXPECTED_CLAIM_VALUE_MESSAGE_TEMPLATE = "Missing expected '%s' value in '%s' claim %s.";
    public static final String MISSING_JWS_ALG_MSG = "JWS header does not contain a required 'alg' (Algorithm) header parameter.  This header parameter is mandatory per the JWS Specification, Section 4.1.1. See https://www.rfc-editor.org/rfc/rfc7515.html#section-4.1.1 for more information.";
    public static final String MISSING_JWE_ALG_MSG = "JWE header does not contain a required 'alg' (Algorithm) header parameter.  This header parameter is mandatory per the JWE Specification, Section 4.1.1. See https://www.rfc-editor.org/rfc/rfc7516.html#section-4.1.1 for more information.";
    public static final String MISSING_JWS_DIGEST_MSG_FMT = "The JWS header references signature algorithm '%s' but the compact JWE string is missing the required signature.";
    public static final String MISSING_JWE_DIGEST_MSG_FMT = "The JWE header references key management algorithm '%s' but the compact JWE string is missing the required AAD authentication tag.";
    private static final String MISSING_ENC_MSG = "JWE header does not contain a required 'enc' (Encryption Algorithm) header parameter.  This header parameter is mandatory per the JWE Specification, Section 4.1.2. See https://www.rfc-editor.org/rfc/rfc7516.html#section-4.1.2 for more information.";
    private static final String UNSECURED_DISABLED_MSG_PREFIX = "Unsecured JWSs (those with an " + DefaultHeader.ALGORITHM + " header value of '" + Jwts.SIG.NONE.getId() + "') are disallowed by " + "default as mandated by https://www.rfc-editor.org/rfc/rfc7518.html#section-3.6. If you wish to " + "allow them to be parsed, call the JwtParserBuilder.unsecured() method, but please read the " + "security considerations covered in that method's JavaDoc before doing so. Header: ";
    private static final String CRIT_UNSECURED_MSG = "Unsecured JWSs (those with an " + DefaultHeader.ALGORITHM + " header value of '" + Jwts.SIG.NONE.getId() + "') may not use the " + DefaultProtectedHeader.CRIT + " header parameter per https://www.rfc-editor.org/rfc/rfc7515.html#section-4.1.11 (\"the [crit] Header " + "Parameter MUST be integrity protected; therefore, it MUST occur only within [a] JWS Protected Header)\"." + " Header: %s";
    private static final String CRIT_MISSING_MSG = "Protected Header " + DefaultProtectedHeader.CRIT + " set references header name '%s', but the header does not contain an " + "associated '%s' header parameter as required by " + "https://www.rfc-editor.org/rfc/rfc7515.html#section-4.1.11. Header: %s";
    private static final String CRIT_UNSUPPORTED_MSG = "Protected Header " + DefaultProtectedHeader.CRIT + " set references unsupported header name '%s'. Application developers expecting to support a JWT " + "extension using header '%s' in their application code must indicate it " + "is supported by using the JwtParserBuilder.critical method. Header: %s";
    private static final String JWE_NONE_MSG = "JWEs do not support key management " + DefaultHeader.ALGORITHM + " header value '" + Jwts.SIG.NONE.getId() + "' per " + "https://www.rfc-editor.org/rfc/rfc7518.html#section-4.1";
    private static final String JWS_NONE_SIG_MISMATCH_MSG = "The JWS header references signature algorithm '" + Jwts.SIG.NONE.getId() + "' yet the compact JWS string contains a signature. This is not permitted " + "per https://tools.ietf.org/html/rfc7518#section-3.6.";
    private static final String B64_MISSING_PAYLOAD = "Unable to verify JWS signature: the parser has encountered an Unencoded Payload JWS with detached payload, but the detached payload value required for signature verification has not been provided. If you expect to receive and parse Unencoded Payload JWSs in your application, the overloaded JwtParser.parseSignedContent or JwtParser.parseSignedClaims methods that accept a byte[] or InputStream must be used for these kinds of JWSs. Header: %s";
    private static final String B64_DECOMPRESSION_MSG = "The JWT header references compression algorithm '%s', but payload decompression for Unencoded JWSs (those with an " + DefaultJwsHeader.B64 + " header value of false) that rely on a SigningKeyResolver are disallowed " + "by default to protect against [Denial of Service attacks](" + "https://www.usenix.org/system/files/conference/usenixsecurity15/sec15-paper-pellegrino.pdf).  If you " + "wish to enable Unencoded JWS payload decompression, configure the JwtParserBuilder." + "keyLocator(Locator) and do not configure a SigningKeyResolver.";
    private static final String UNPROTECTED_DECOMPRESSION_MSG = "The JWT header references compression algorithm '%s', but payload decompression for Unprotected JWTs (those with an " + DefaultHeader.ALGORITHM + " header value of '" + Jwts.SIG.NONE.getId() + "') or Unencoded JWSs (those with a " + DefaultJwsHeader.B64 + " header value of false) that also rely on a SigningKeyResolver are disallowed " + "by default to protect against [Denial of Service attacks](" + "https://www.usenix.org/system/files/conference/usenixsecurity15/sec15-paper-pellegrino.pdf).  If you " + "wish to enable Unsecure JWS or Unencoded JWS payload decompression, call the JwtParserBuilder." + "unsecuredDecompression() method, but please read the security considerations covered in that " + "method's JavaDoc before doing so.";
    private final Provider provider;
    private final SigningKeyResolver signingKeyResolver;
    private final boolean unsecured;
    private final boolean unsecuredDecompression;
    private final Function<JwsHeader, SecureDigestAlgorithm<?, ?>> sigAlgs;
    private final Function<JweHeader, AeadAlgorithm> encAlgs;
    private final Function<JweHeader, KeyAlgorithm<?, ?>> keyAlgs;
    private final Function<Header, CompressionAlgorithm> zipAlgs;
    private final Locator<? extends Key> keyLocator;
    private final Decoder<InputStream, InputStream> decoder;
    private final Deserializer<Map<String, ?>> deserializer;
    private final ClaimsBuilder expectedClaims;
    private final Clock clock;
    private final Set<String> critical;
    private final long allowedClockSkewMillis;

    DefaultJwtParser(Provider provider, SigningKeyResolver signingKeyResolver, boolean unsecured, boolean unsecuredDecompression, Locator<? extends Key> keyLocator, Clock clock, Set<String> critical, long allowedClockSkewMillis, DefaultClaims expectedClaims, Decoder<InputStream, InputStream> base64UrlDecoder, Deserializer<Map<String, ?>> deserializer, CompressionCodecResolver compressionCodecResolver, Registry<String, CompressionAlgorithm> zipAlgs, Registry<String, SecureDigestAlgorithm<?, ?>> sigAlgs, Registry<String, KeyAlgorithm<?, ?>> keyAlgs, Registry<String, AeadAlgorithm> encAlgs) {
        this.provider = provider;
        this.unsecured = unsecured;
        this.unsecuredDecompression = unsecuredDecompression;
        this.signingKeyResolver = signingKeyResolver;
        this.keyLocator = Assert.notNull(keyLocator, "Key Locator cannot be null.");
        this.clock = Assert.notNull(clock, "Clock cannot be null.");
        this.critical = Collections.nullSafe(critical);
        this.allowedClockSkewMillis = allowedClockSkewMillis;
        this.expectedClaims = (ClaimsBuilder)Jwts.claims().add(expectedClaims);
        this.decoder = Assert.notNull(base64UrlDecoder, "base64UrlDecoder cannot be null.");
        this.deserializer = Assert.notNull(deserializer, "JSON Deserializer cannot be null.");
        this.sigAlgs = new IdLocator(DefaultHeader.ALGORITHM, sigAlgs, "mac or signature", "signature verification", MISSING_JWS_ALG_MSG);
        this.keyAlgs = new IdLocator(DefaultHeader.ALGORITHM, keyAlgs, "key management", "decryption", MISSING_JWE_ALG_MSG);
        this.encAlgs = new IdLocator<JweHeader, AeadAlgorithm>(DefaultJweHeader.ENCRYPTION_ALGORITHM, encAlgs, "encryption", "decryption", MISSING_ENC_MSG);
        this.zipAlgs = compressionCodecResolver != null ? new CompressionCodecLocator(compressionCodecResolver) : new IdLocator(DefaultHeader.COMPRESSION_ALGORITHM, zipAlgs, "compression", "decompression", null);
    }

    @Override
    public boolean isSigned(CharSequence compact) {
        if (!Strings.hasText(compact)) {
            return false;
        }
        try {
            Object tokenized = jwtTokenizer.tokenize(new CharSequenceReader(compact));
            return !(tokenized instanceof TokenizedJwe) && Strings.hasText(tokenized.getDigest());
        }
        catch (MalformedJwtException e) {
            return false;
        }
    }

    private static boolean hasContentType(Header header) {
        return header != null && Strings.hasText(header.getContentType());
    }

    private byte[] verifySignature(TokenizedJwt tokenized, JwsHeader jwsHeader, String alg, SigningKeyResolver resolver2, Claims claims, Payload payload) {
        InputStream verificationInput;
        SecureDigestAlgorithm<?, ?> algorithm;
        Assert.notNull(resolver2, "SigningKeyResolver instance cannot be null.");
        try {
            algorithm = this.sigAlgs.apply(jwsHeader);
        }
        catch (UnsupportedJwtException e) {
            String msg = "Unsupported signature algorithm '" + alg + "': " + e.getMessage();
            throw new SignatureException(msg, e);
        }
        Assert.stateNotNull(algorithm, "JWS Signature Algorithm cannot be null.");
        Key key = claims != null ? resolver2.resolveSigningKey(jwsHeader, claims) : resolver2.resolveSigningKey(jwsHeader, payload.getBytes());
        if (key == null) {
            String msg = "Cannot verify JWS signature: unable to locate signature verification key for JWS with header: " + jwsHeader;
            throw new UnsupportedJwtException(msg);
        }
        Provider provider = ProviderKey.getProvider(key, this.provider);
        key = ProviderKey.getKey(key);
        Assert.stateNotNull(key, "ProviderKey cannot be null.");
        if (key instanceof PrivateKey) {
            throw new InvalidKeyException(PRIV_KEY_VERIFY_MSG);
        }
        byte[] signature = this.decode(tokenized.getDigest(), "JWS signature");
        InputStream payloadStream = null;
        if (jwsHeader.isPayloadEncoded()) {
            int len = tokenized.getProtected().length() + 1 + tokenized.getPayload().length();
            CharBuffer cb = CharBuffer.allocate(len);
            cb.put(Strings.wrap(tokenized.getProtected()));
            cb.put('.');
            cb.put(Strings.wrap(tokenized.getPayload()));
            cb.rewind();
            ByteBuffer bb = StandardCharsets.US_ASCII.encode(cb);
            bb.rewind();
            byte[] data = new byte[bb.remaining()];
            bb.get(data);
            verificationInput = Streams.of(data);
        } else {
            ByteBuffer headerBuf = StandardCharsets.US_ASCII.encode(Strings.wrap(tokenized.getProtected()));
            headerBuf.rewind();
            ByteBuffer buf = ByteBuffer.allocate(headerBuf.remaining() + 1);
            buf.put(headerBuf);
            buf.put((byte)46);
            buf.rewind();
            byte[] data = new byte[buf.remaining()];
            buf.get(data);
            InputStream prefixStream = Streams.of(data);
            payloadStream = payload.toInputStream();
            verificationInput = new SequenceInputStream(prefixStream, new UncloseableInputStream(payloadStream));
        }
        try {
            DefaultVerifySecureDigestRequest<Key> request = new DefaultVerifySecureDigestRequest<Key>(verificationInput, provider, null, key, signature);
            if (!algorithm.verify(request)) {
                String msg = "JWT signature does not match locally computed signature. JWT validity cannot be asserted and should not be trusted.";
                throw new SignatureException(msg);
            }
        }
        catch (WeakKeyException e) {
            throw e;
        }
        catch (InvalidKeyException | IllegalArgumentException e) {
            String algId = algorithm.getId();
            String msg = "The parsed JWT indicates it was signed with the '" + algId + "' signature " + "algorithm, but the provided " + key.getClass().getName() + " key may " + "not be used to verify " + algId + " signatures.  Because the specified " + "key reflects a specific and expected algorithm, and the JWT does not reflect " + "this algorithm, it is likely that the JWT was not expected and therefore should not be " + "trusted.  Another possibility is that the parser was provided the incorrect " + "signature verification key, but this cannot be assumed for security reasons.";
            throw new UnsupportedJwtException(msg, e);
        }
        finally {
            Streams.reset(payloadStream);
        }
        return signature;
    }

    @Override
    public Jwt<?, ?> parse(Reader reader) {
        Assert.notNull(reader, "Reader cannot be null.");
        return this.parse(reader, Payload.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jwt<?, ?> parse(Reader compact, Payload unencodedPayload) {
        boolean allowSkew;
        DefaultJwt<Header, byte[]> jwt;
        byte[] body2;
        String msg;
        Payload payload;
        boolean payloadBase64UrlEncoded;
        Header header;
        Assert.notNull(compact, "Compact reader cannot be null.");
        Assert.stateNotNull(unencodedPayload, "internal error: unencodedPayload is null.");
        Object tokenized = jwtTokenizer.tokenize(compact);
        CharSequence base64UrlHeader = tokenized.getProtected();
        if (!Strings.hasText(base64UrlHeader)) {
            String msg2 = "Compact JWT strings MUST always have a Base64Url protected header per https://tools.ietf.org/html/rfc7519#section-7.2 (steps 2-4).";
            throw new MalformedJwtException(msg2);
        }
        byte[] headerBytes = this.decode(base64UrlHeader, "protected header");
        Map<String, ?> m = this.deserialize(Streams.of(headerBytes), "protected header");
        try {
            header = tokenized.createHeader(m);
        }
        catch (Exception e) {
            String msg3 = "Invalid protected header: " + e.getMessage();
            throw new MalformedJwtException(msg3, e);
        }
        String alg = Strings.clean(header.getAlgorithm());
        if (!Strings.hasText(alg)) {
            String msg4 = tokenized instanceof TokenizedJwe ? MISSING_JWE_ALG_MSG : MISSING_JWS_ALG_MSG;
            throw new MalformedJwtException(msg4);
        }
        boolean unsecured = Jwts.SIG.NONE.getId().equalsIgnoreCase(alg);
        CharSequence base64UrlDigest = tokenized.getDigest();
        boolean hasDigest = Strings.hasText(base64UrlDigest);
        if (unsecured) {
            if (tokenized instanceof TokenizedJwe) {
                throw new MalformedJwtException(JWE_NONE_MSG);
            }
            if (!this.unsecured) {
                String msg5 = UNSECURED_DISABLED_MSG_PREFIX + header;
                throw new UnsupportedJwtException(msg5);
            }
            if (hasDigest) {
                throw new MalformedJwtException(JWS_NONE_SIG_MISMATCH_MSG);
            }
            if (header.containsKey(DefaultProtectedHeader.CRIT.getId())) {
                String msg6 = String.format(CRIT_UNSECURED_MSG, header);
                throw new MalformedJwtException(msg6);
            }
        } else if (!hasDigest) {
            String fmt = tokenized instanceof TokenizedJwe ? MISSING_JWE_DIGEST_MSG_FMT : MISSING_JWS_DIGEST_MSG_FMT;
            String msg7 = String.format(fmt, alg);
            throw new MalformedJwtException(msg7);
        }
        if (header instanceof ProtectedHeader) {
            Set<String> crit = Collections.nullSafe(((ProtectedHeader)header).getCritical());
            Set<String> supportedCrit = this.critical;
            String b64Id = DefaultJwsHeader.B64.getId();
            if (!unencodedPayload.isEmpty() && !this.critical.contains(b64Id)) {
                supportedCrit = new LinkedHashSet<String>(Collections.size(this.critical) + 1);
                supportedCrit.add(DefaultJwsHeader.B64.getId());
                supportedCrit.addAll(this.critical);
            }
            for (String name : crit) {
                if (!header.containsKey(name)) {
                    String msg8 = String.format(CRIT_MISSING_MSG, name, name, header);
                    throw new MalformedJwtException(msg8);
                }
                if (supportedCrit.contains(name)) continue;
                String msg9 = String.format(CRIT_UNSUPPORTED_MSG, name, name, header);
                throw new UnsupportedJwtException(msg9);
            }
        }
        CharSequence payloadToken = tokenized.getPayload();
        boolean integrityVerified = false;
        boolean bl = payloadBase64UrlEncoded = !(header instanceof JwsHeader) || ((JwsHeader)header).isPayloadEncoded();
        if (payloadBase64UrlEncoded) {
            byte[] data = this.decode(payloadToken, "payload");
            payload = new Payload(data, header.getContentType());
        } else if (Strings.hasText(payloadToken)) {
            payload = new Payload(payloadToken, header.getContentType());
        } else {
            if (unencodedPayload.isEmpty()) {
                msg = String.format(B64_MISSING_PAYLOAD, header);
                throw new SignatureException(msg);
            }
            payload = unencodedPayload;
        }
        if (tokenized instanceof TokenizedJwe && payload.isEmpty()) {
            msg = "Compact JWE strings MUST always contain a payload (ciphertext).";
            throw new MalformedJwtException(msg);
        }
        byte[] iv = null;
        byte[] digest = null;
        if (tokenized instanceof TokenizedJwe) {
            TokenizedJwe tokenizedJwe = (TokenizedJwe)tokenized;
            JweHeader jweHeader = Assert.stateIsInstance(JweHeader.class, header, "Not a JweHeader. ");
            AeadAlgorithm encAlg = this.encAlgs.apply(jweHeader);
            Assert.stateNotNull(encAlg, "JWE Encryption Algorithm cannot be null.");
            KeyAlgorithm<?, ?> keyAlg = this.keyAlgs.apply(jweHeader);
            Assert.stateNotNull(keyAlg, "JWE Key Algorithm cannot be null.");
            byte[] cekBytes = Bytes.EMPTY;
            CharSequence base64Url = tokenizedJwe.getEncryptedKey();
            if (Strings.hasText(base64Url) && Bytes.isEmpty(cekBytes = this.decode(base64Url, "JWE encrypted key"))) {
                String msg10 = "Compact JWE string represents an encrypted key, but the key is empty.";
                throw new MalformedJwtException(msg10);
            }
            base64Url = tokenizedJwe.getIv();
            if (Strings.hasText(base64Url)) {
                iv = this.decode(base64Url, "JWE Initialization Vector");
            }
            if (Bytes.isEmpty(iv)) {
                String msg11 = "Compact JWE strings must always contain an Initialization Vector.";
                throw new MalformedJwtException(msg11);
            }
            ByteBuffer buf = StandardCharsets.US_ASCII.encode(Strings.wrap(base64UrlHeader));
            byte[] aadBytes = new byte[buf.remaining()];
            buf.get(aadBytes);
            InputStream aad = Streams.of(aadBytes);
            base64Url = base64UrlDigest;
            Assert.hasText(base64Url, "JWE AAD Authentication Tag cannot be null or empty.");
            digest = this.decode(base64Url, "JWE AAD Authentication Tag");
            if (Bytes.isEmpty(digest)) {
                String msg12 = "Compact JWE strings must always contain an AAD Authentication Tag.";
                throw new MalformedJwtException(msg12);
            }
            Key key = this.keyLocator.locate(jweHeader);
            if (key == null) {
                String msg13 = "Cannot decrypt JWE payload: unable to locate key for JWE with header: " + jweHeader;
                throw new UnsupportedJwtException(msg13);
            }
            if (key instanceof PublicKey) {
                throw new InvalidKeyException(PUB_KEY_DECRYPT_MSG);
            }
            Provider provider = ProviderKey.getProvider(key, this.provider);
            DefaultDecryptionKeyRequest<Key> request = new DefaultDecryptionKeyRequest<Key>(cekBytes, provider, null, jweHeader, encAlg, key = ProviderKey.getKey(key));
            SecretKey cek = keyAlg.getDecryptionKey(request);
            if (cek == null) {
                String msg14 = "The '" + keyAlg.getId() + "' JWE key algorithm did not return a decryption key. " + "Unable to perform '" + encAlg.getId() + "' decryption.";
                throw new IllegalStateException(msg14);
            }
            InputStream ciphertext = payload.toInputStream();
            ByteArrayOutputStream plaintext = new ByteArrayOutputStream(8192);
            DefaultDecryptAeadRequest dreq = new DefaultDecryptAeadRequest(ciphertext, cek, aad, iv, digest);
            encAlg.decrypt(dreq, plaintext);
            payload = new Payload(plaintext.toByteArray(), header.getContentType());
            integrityVerified = true;
        } else if (hasDigest && this.signingKeyResolver == null) {
            JwsHeader jwsHeader = Assert.stateIsInstance(JwsHeader.class, header, "Not a JwsHeader. ");
            digest = this.verifySignature((TokenizedJwt)tokenized, jwsHeader, alg, new LocatingKeyResolver(this.keyLocator), null, payload);
            integrityVerified = true;
        }
        CompressionAlgorithm compressionAlgorithm = this.zipAlgs.apply(header);
        if (compressionAlgorithm != null) {
            if (!integrityVerified) {
                String msg15;
                if (!payloadBase64UrlEncoded) {
                    msg15 = String.format(B64_DECOMPRESSION_MSG, compressionAlgorithm.getId());
                    throw new UnsupportedJwtException(msg15);
                }
                if (!this.unsecuredDecompression) {
                    msg15 = String.format(UNPROTECTED_DECOMPRESSION_MSG, compressionAlgorithm.getId());
                    throw new UnsupportedJwtException(msg15);
                }
            }
            payload = payload.decompress(compressionAlgorithm);
        }
        Object claims = null;
        byte[] payloadBytes = payload.getBytes();
        if (payload.isConsumable()) {
            InputStream in;
            block59: {
                in = null;
                try {
                    in = payload.toInputStream();
                    if (!DefaultJwtParser.hasContentType(header)) {
                        Map<String, ?> claimsMap = null;
                        try {
                            if (!in.markSupported()) {
                                in = new BufferedInputStream(in);
                                in.mark(0);
                            }
                            claimsMap = this.deserialize(new UncloseableInputStream(in), "claims");
                        }
                        catch (MalformedJwtException | DeserializationException base64Url) {
                        }
                        finally {
                            Streams.reset(in);
                        }
                        if (claimsMap != null) {
                            try {
                                claims = new DefaultClaims(claimsMap);
                            }
                            catch (Throwable t) {
                                String msg16 = "Invalid claims: " + t.getMessage();
                                throw new MalformedJwtException(msg16);
                            }
                        }
                    }
                    if (claims != null) break block59;
                    payloadBytes = Streams.bytes(in, "Unable to convert payload to byte array.");
                }
                catch (Throwable throwable) {
                    Objects.nullSafeClose(in);
                    throw throwable;
                }
            }
            Objects.nullSafeClose(in);
        }
        if (hasDigest && this.signingKeyResolver != null) {
            JwsHeader jwsHeader = Assert.stateIsInstance(JwsHeader.class, header, "Not a JwsHeader. ");
            digest = this.verifySignature((TokenizedJwt)tokenized, jwsHeader, alg, this.signingKeyResolver, (Claims)claims, payload);
            integrityVerified = true;
        }
        Object object = body2 = (Object)(claims != null ? claims : payloadBytes);
        if (header instanceof JweHeader) {
            jwt = new DefaultJwe<byte[]>((JweHeader)header, body2, iv, digest);
        } else if (hasDigest) {
            JwsHeader jwsHeader = Assert.isInstanceOf(JwsHeader.class, header, "JwsHeader required.");
            jwt = new DefaultJws<byte[]>(jwsHeader, body2, digest, base64UrlDigest.toString());
        } else {
            jwt = new DefaultJwt<Header, byte[]>(header, body2);
        }
        boolean bl2 = allowSkew = this.allowedClockSkewMillis > 0L;
        if (claims != null) {
            Date nbf;
            Date now = this.clock.now();
            long nowTime = now.getTime();
            Date exp = claims.getExpiration();
            if (exp != null) {
                Date max;
                long maxTime = nowTime - this.allowedClockSkewMillis;
                Date date = max = allowSkew ? new Date(maxTime) : now;
                if (max.after(exp)) {
                    String expVal = DateFormats.formatIso8601(exp, true);
                    String nowVal = DateFormats.formatIso8601(now, true);
                    long differenceMillis = nowTime - exp.getTime();
                    String msg17 = "JWT expired " + differenceMillis + " milliseconds ago at " + expVal + ". " + "Current time: " + nowVal + ". Allowed clock skew: " + this.allowedClockSkewMillis + " milliseconds.";
                    throw new ExpiredJwtException(header, (Claims)claims, msg17);
                }
            }
            if ((nbf = claims.getNotBefore()) != null) {
                Date min;
                long minTime = nowTime + this.allowedClockSkewMillis;
                Date date = min = allowSkew ? new Date(minTime) : now;
                if (min.before(nbf)) {
                    String nbfVal = DateFormats.formatIso8601(nbf, true);
                    String nowVal = DateFormats.formatIso8601(now, true);
                    long differenceMillis = nbf.getTime() - nowTime;
                    String msg18 = "JWT early by " + differenceMillis + " milliseconds before " + nbfVal + ". Current time: " + nowVal + ". Allowed clock skew: " + this.allowedClockSkewMillis + " milliseconds.";
                    throw new PrematureJwtException(header, (Claims)claims, msg18);
                }
            }
            this.validateExpectedClaims(header, (Claims)claims);
        }
        return jwt;
    }

    private static Object normalize(Object o) {
        if (o instanceof Integer) {
            o = ((Integer)o).longValue();
        }
        return o;
    }

    private void validateExpectedClaims(Header header, Claims claims) {
        Claims expected = (Claims)this.expectedClaims.build();
        for (String expectedClaimName : expected.keySet()) {
            String msg;
            Object expectedClaimValue = DefaultJwtParser.normalize(expected.get(expectedClaimName));
            Object actualClaimValue = DefaultJwtParser.normalize(claims.get(expectedClaimName));
            if (expectedClaimValue instanceof Date) {
                try {
                    actualClaimValue = claims.get(expectedClaimName, Date.class);
                }
                catch (Exception e) {
                    msg = "JWT Claim '" + expectedClaimName + "' was expected to be a Date, but its value " + "cannot be converted to a Date using current heuristics.  Value: " + actualClaimValue;
                    throw new IncorrectClaimException(header, claims, expectedClaimName, expectedClaimValue, msg);
                }
            }
            if (actualClaimValue == null) {
                boolean collection = expectedClaimValue instanceof Collection;
                msg = "Missing '" + expectedClaimName + "' claim. Expected value";
                msg = collection ? msg + "s: " + expectedClaimValue : msg + ": " + expectedClaimValue;
                throw new MissingClaimException(header, claims, expectedClaimName, expectedClaimValue, msg);
            }
            if (expectedClaimValue instanceof Collection) {
                Collection expectedValues = (Collection)expectedClaimValue;
                Set<Object> actualValues = actualClaimValue instanceof Collection ? (Set<Object>)actualClaimValue : Collections.setOf(actualClaimValue);
                for (Object expectedValue : expectedValues) {
                    if (Collections.contains(actualValues.iterator(), expectedValue)) continue;
                    String msg2 = String.format(MISSING_EXPECTED_CLAIM_VALUE_MESSAGE_TEMPLATE, expectedValue, expectedClaimName, actualValues);
                    throw new IncorrectClaimException(header, claims, expectedClaimName, expectedClaimValue, msg2);
                }
                continue;
            }
            if (expectedClaimValue.equals(actualClaimValue)) continue;
            String msg3 = String.format(INCORRECT_EXPECTED_CLAIM_MESSAGE_TEMPLATE, expectedClaimName, expectedClaimValue, actualClaimValue);
            throw new IncorrectClaimException(header, claims, expectedClaimName, expectedClaimValue, msg3);
        }
    }

    @Override
    public <T> T parse(CharSequence compact, JwtHandler<T> handler) {
        return this.parse(compact, Payload.EMPTY).accept(handler);
    }

    private Jwt<?, ?> parse(CharSequence compact, Payload unencodedPayload) {
        Assert.hasText(compact, "JWT String argument cannot be null or empty.");
        return this.parse(new CharSequenceReader(compact), unencodedPayload);
    }

    @Override
    public Jwt<Header, byte[]> parseContentJwt(CharSequence jwt) {
        return ((Jwt)this.parse(jwt)).accept(Jwt.UNSECURED_CONTENT);
    }

    @Override
    public Jwt<Header, Claims> parseClaimsJwt(CharSequence jwt) {
        return ((Jwt)this.parse(jwt)).accept(Jwt.UNSECURED_CLAIMS);
    }

    @Override
    public Jws<byte[]> parseContentJws(CharSequence jws) {
        return this.parseSignedContent(jws);
    }

    @Override
    public Jws<Claims> parseClaimsJws(CharSequence jws) {
        return this.parseSignedClaims(jws);
    }

    @Override
    public Jwt<Header, byte[]> parseUnsecuredContent(CharSequence jwt) throws JwtException, IllegalArgumentException {
        return ((Jwt)this.parse(jwt)).accept(Jwt.UNSECURED_CONTENT);
    }

    @Override
    public Jwt<Header, Claims> parseUnsecuredClaims(CharSequence jwt) throws JwtException, IllegalArgumentException {
        return ((Jwt)this.parse(jwt)).accept(Jwt.UNSECURED_CLAIMS);
    }

    @Override
    public Jws<byte[]> parseSignedContent(CharSequence compact) {
        return ((Jwt)this.parse(compact)).accept(Jws.CONTENT);
    }

    private Jws<byte[]> parseSignedContent(CharSequence jws, Payload unencodedPayload) {
        return this.parse(jws, unencodedPayload).accept(Jws.CONTENT);
    }

    @Override
    public Jws<Claims> parseSignedClaims(CharSequence compact) {
        return ((Jwt)this.parse(compact)).accept(Jws.CLAIMS);
    }

    private Jws<Claims> parseSignedClaims(CharSequence jws, Payload unencodedPayload) {
        unencodedPayload.setClaimsExpected(true);
        return this.parse(jws, unencodedPayload).accept(Jws.CLAIMS);
    }

    @Override
    public Jws<byte[]> parseSignedContent(CharSequence jws, byte[] unencodedPayload) {
        Assert.notEmpty(unencodedPayload, "unencodedPayload argument cannot be null or empty.");
        return this.parseSignedContent(jws, new Payload(unencodedPayload, null));
    }

    private static Payload payloadFor(InputStream in) {
        if (in instanceof BytesInputStream) {
            byte[] data = Streams.bytes(in, "Unable to obtain payload InputStream bytes.");
            return new Payload(data, null);
        }
        return new Payload(in, null);
    }

    @Override
    public Jws<byte[]> parseSignedContent(CharSequence jws, InputStream unencodedPayload) {
        Assert.notNull(unencodedPayload, "unencodedPayload InputStream cannot be null.");
        return this.parseSignedContent(jws, DefaultJwtParser.payloadFor(unencodedPayload));
    }

    @Override
    public Jws<Claims> parseSignedClaims(CharSequence jws, byte[] unencodedPayload) {
        Assert.notEmpty(unencodedPayload, "unencodedPayload argument cannot be null or empty.");
        return this.parseSignedClaims(jws, new Payload(unencodedPayload, null));
    }

    @Override
    public Jws<Claims> parseSignedClaims(CharSequence jws, InputStream unencodedPayload) {
        Assert.notNull(unencodedPayload, "unencodedPayload InputStream cannot be null.");
        byte[] bytes = Streams.bytes(unencodedPayload, "Unable to obtain Claims bytes from unencodedPayload InputStream");
        return this.parseSignedClaims(jws, new Payload(bytes, null));
    }

    @Override
    public Jwe<byte[]> parseEncryptedContent(CharSequence compact) throws JwtException {
        return ((Jwt)this.parse(compact)).accept(Jwe.CONTENT);
    }

    @Override
    public Jwe<Claims> parseEncryptedClaims(CharSequence compact) throws JwtException {
        return ((Jwt)this.parse(compact)).accept(Jwe.CLAIMS);
    }

    protected byte[] decode(CharSequence base64UrlEncoded, String name) {
        try {
            InputStream decoding = this.decoder.decode(Streams.of(Strings.utf8(base64UrlEncoded)));
            return Streams.bytes(decoding, "Unable to Base64Url-decode input.");
        }
        catch (Throwable t) {
            String value = "payload".equals(name) ? "<redacted>" : base64UrlEncoded.toString();
            String msg = "Invalid Base64Url " + name + ": " + value;
            throw new MalformedJwtException(msg, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ?> deserialize(InputStream in, String name) {
        Map<String, ?> map;
        try {
            Reader reader = Streams.reader(in);
            JsonObjectDeserializer deserializer = new JsonObjectDeserializer(this.deserializer, name);
            map = deserializer.apply(reader);
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(in);
            throw throwable;
        }
        Objects.nullSafeClose(in);
        return map;
    }
}

