/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.CheckedFunction;
import io.jsonwebtoken.impl.security.AbstractSignatureAlgorithm;
import io.jsonwebtoken.impl.security.DefaultKeyPairBuilder;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.impl.security.Randoms;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeyPairBuilder;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SignatureAlgorithm;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.VerifySecureDigestRequest;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

final class EcSignatureAlgorithm
extends AbstractSignatureAlgorithm {
    private static final String REQD_ORDER_BIT_LENGTH_MSG = "orderBitLength must equal 256, 384, or 521.";
    private static final String DER_ENCODING_SYS_PROPERTY_NAME = "io.jsonwebtoken.impl.crypto.EllipticCurveSignatureValidator.derEncodingSupported";
    private static final String ES256_OID = "1.2.840.10045.4.3.2";
    private static final String ES384_OID = "1.2.840.10045.4.3.3";
    private static final String ES512_OID = "1.2.840.10045.4.3.4";
    private static final Set<String> KEY_ALG_NAMES = Collections.setOf("EC", "ECDSA", "1.2.840.10045.4.3.2", "1.2.840.10045.4.3.3", "1.2.840.10045.4.3.4");
    private final ECGenParameterSpec KEY_PAIR_GEN_PARAMS;
    private final int orderBitLength;
    private final String OID;
    private final int signatureByteLength;
    private final int sigFieldByteLength;
    static final EcSignatureAlgorithm ES256 = new EcSignatureAlgorithm(256, "1.2.840.10045.4.3.2");
    static final EcSignatureAlgorithm ES384 = new EcSignatureAlgorithm(384, "1.2.840.10045.4.3.3");
    static final EcSignatureAlgorithm ES512 = new EcSignatureAlgorithm(521, "1.2.840.10045.4.3.4");
    private static final Map<String, SignatureAlgorithm> BY_OID = new LinkedHashMap<String, SignatureAlgorithm>(3);

    private static int shaSize(int orderBitLength) {
        return orderBitLength == 521 ? 512 : orderBitLength;
    }

    private static boolean isSupportedOrderBitLength(int orderBitLength) {
        return orderBitLength == 256 || orderBitLength == 384 || orderBitLength == 521;
    }

    static SignatureAlgorithm findByKey(Key key) {
        String algName = KeysBridge.findAlgorithm(key);
        if (!Strings.hasText(algName)) {
            return null;
        }
        SignatureAlgorithm alg = BY_OID.get(algName = algName.toUpperCase(Locale.ENGLISH));
        if (alg != null) {
            return alg;
        }
        if ("EC".equalsIgnoreCase(algName) || "ECDSA".equalsIgnoreCase(algName)) {
            int bitLength = KeysBridge.findBitLength(key);
            if (bitLength == EcSignatureAlgorithm.ES512.orderBitLength) {
                return ES512;
            }
            if (bitLength == EcSignatureAlgorithm.ES384.orderBitLength) {
                return ES384;
            }
            if (bitLength == EcSignatureAlgorithm.ES256.orderBitLength) {
                return ES256;
            }
        }
        return null;
    }

    private EcSignatureAlgorithm(int orderBitLength, String oid) {
        super("ES" + EcSignatureAlgorithm.shaSize(orderBitLength), "SHA" + EcSignatureAlgorithm.shaSize(orderBitLength) + "withECDSA");
        Assert.isTrue(EcSignatureAlgorithm.isSupportedOrderBitLength(orderBitLength), REQD_ORDER_BIT_LENGTH_MSG);
        this.OID = Assert.hasText(oid, "Invalid OID.");
        String curveName = "secp" + orderBitLength + "r1";
        this.KEY_PAIR_GEN_PARAMS = new ECGenParameterSpec(curveName);
        this.orderBitLength = orderBitLength;
        this.sigFieldByteLength = Bytes.length(this.orderBitLength);
        this.signatureByteLength = this.sigFieldByteLength * 2;
    }

    @Override
    public KeyPairBuilder keyPair() {
        return (KeyPairBuilder)new DefaultKeyPairBuilder("EC", this.KEY_PAIR_GEN_PARAMS).random(Randoms.secureRandom());
    }

    @Override
    protected void validateKey(Key key, boolean signing) {
        super.validateKey(key, signing);
        if (!KEY_ALG_NAMES.contains(KeysBridge.findAlgorithm(key))) {
            throw new InvalidKeyException("Unrecognized EC key algorithm name.");
        }
        int size = KeysBridge.findBitLength(key);
        if (size < 0) {
            return;
        }
        int sigFieldByteLength = Bytes.length(size);
        int concatByteLength = sigFieldByteLength * 2;
        if (concatByteLength != this.signatureByteLength) {
            String msg = "The provided Elliptic Curve " + EcSignatureAlgorithm.keyType(signing) + " key size (aka order bit length) is " + Bytes.bitsMsg(size) + ", but the '" + this.getId() + "' algorithm requires EC Keys with " + Bytes.bitsMsg(this.orderBitLength) + " per [RFC 7518, Section 3.4](https://www.rfc-editor.org/rfc/rfc7518.html#section-3.4).";
            throw new InvalidKeyException(msg);
        }
    }

    @Override
    protected byte[] doDigest(final SecureRequest<InputStream, PrivateKey> request) {
        return this.jca(request).withSignature(new CheckedFunction<Signature, byte[]>(){

            @Override
            public byte[] apply(Signature sig) throws Exception {
                sig.initSign((PrivateKey)KeysBridge.root(request));
                byte[] signature = EcSignatureAlgorithm.this.sign(sig, (InputStream)request.getPayload());
                return EcSignatureAlgorithm.transcodeDERToConcat(signature, EcSignatureAlgorithm.this.signatureByteLength);
            }
        });
    }

    boolean isValidRAndS(PublicKey key, byte[] concatSignature) {
        if (key instanceof ECKey) {
            ECKey ecKey = (ECKey)((Object)key);
            BigInteger order = ecKey.getParams().getOrder();
            BigInteger r = new BigInteger(1, Arrays.copyOfRange(concatSignature, 0, this.sigFieldByteLength));
            BigInteger s = new BigInteger(1, Arrays.copyOfRange(concatSignature, this.sigFieldByteLength, concatSignature.length));
            return r.signum() >= 1 && s.signum() >= 1 && r.compareTo(order) < 0 && s.compareTo(order) < 0;
        }
        return true;
    }

    @Override
    protected boolean doVerify(final VerifySecureDigestRequest<PublicKey> request) {
        final PublicKey key = (PublicKey)request.getKey();
        return this.jca(request).withSignature(new CheckedFunction<Signature, Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean apply(Signature sig) {
                byte[] concatSignature = request.getDigest();
                try {
                    byte[] derSignature;
                    block6: {
                        if (EcSignatureAlgorithm.this.signatureByteLength != concatSignature.length) {
                            if (concatSignature[0] == 48 && "true".equalsIgnoreCase(System.getProperty(EcSignatureAlgorithm.DER_ENCODING_SYS_PROPERTY_NAME))) {
                                derSignature = concatSignature;
                                break block6;
                            } else {
                                String msg = "Provided signature is " + Bytes.bytesMsg(concatSignature.length) + " but " + EcSignatureAlgorithm.this.getId() + " signatures must be exactly " + Bytes.bytesMsg(EcSignatureAlgorithm.this.signatureByteLength) + " per [RFC 7518, Section 3.4 (validation)]" + "(https://www.rfc-editor.org/rfc/rfc7518.html#section-3.4).";
                                throw new SignatureException(msg);
                            }
                        }
                        if (!EcSignatureAlgorithm.this.isValidRAndS(key, concatSignature)) {
                            return false;
                        }
                        derSignature = EcSignatureAlgorithm.transcodeConcatToDER(concatSignature);
                    }
                    sig.initVerify(key);
                    return EcSignatureAlgorithm.this.verify(sig, (InputStream)request.getPayload(), derSignature);
                }
                catch (Exception e) {
                    String msg = "Unable to verify Elliptic Curve signature using provided ECPublicKey: " + e.getMessage();
                    throw new SignatureException(msg, e);
                }
            }
        });
    }

    public static byte[] transcodeDERToConcat(byte[] derSignature, int outputLength) throws JwtException {
        int sLength;
        int j;
        int rLength;
        int i;
        int offset;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new JwtException("Invalid ECDSA signature format");
        }
        if (derSignature[1] > 0) {
            offset = 2;
        } else if (derSignature[1] == -127) {
            offset = 3;
        } else {
            throw new JwtException("Invalid ECDSA signature format");
        }
        for (i = rLength = derSignature[offset + 1]; i > 0 && derSignature[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = derSignature[offset + 2 + rLength + 1]; j > 0 && derSignature[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int rawLen = Math.max(i, j);
        rawLen = Math.max(rawLen, outputLength / 2);
        if ((derSignature[offset - 1] & 0xFF) != derSignature.length - offset || (derSignature[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || derSignature[offset] != 2 || derSignature[offset + 2 + rLength] != 2) {
            throw new JwtException("Invalid ECDSA signature format");
        }
        byte[] concatSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, offset + 2 + rLength - i, concatSignature, rawLen - i, i);
        System.arraycopy(derSignature, offset + 2 + rLength + 2 + sLength - j, concatSignature, 2 * rawLen - j, j);
        return concatSignature;
    }

    public static byte[] transcodeConcatToDER(byte[] jwsSignature) throws JwtException {
        try {
            return EcSignatureAlgorithm.concatToDER(jwsSignature);
        }
        catch (Exception e) {
            String msg = "Invalid ECDSA signature format.";
            throw new SignatureException(msg, e);
        }
    }

    private static byte[] concatToDER(byte[] jwsSignature) throws ArrayIndexOutOfBoundsException {
        int offset;
        byte[] derSignature;
        int len;
        int k;
        int rawLen;
        int i;
        for (i = rawLen = jwsSignature.length / 2; i > 0 && jwsSignature[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (jwsSignature[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && jwsSignature[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (jwsSignature[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = 2 + j + 2 + l) > 255) {
            throw new JwtException("Invalid ECDSA signature format");
        }
        if (len < 128) {
            derSignature = new byte[4 + j + 2 + l];
            offset = 1;
        } else {
            derSignature = new byte[5 + j + 2 + l];
            derSignature[1] = -127;
            offset = 2;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)len;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)j;
        System.arraycopy(jwsSignature, rawLen - i, derSignature, offset + j - i, i);
        offset += j;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)l;
        System.arraycopy(jwsSignature, 2 * rawLen - k, derSignature, offset + l - k, k);
        return derSignature;
    }

    static {
        for (EcSignatureAlgorithm alg : Collections.of(ES256, ES384, ES512)) {
            BY_OID.put(alg.OID, alg);
        }
    }
}

