/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_20_2;

import com.mojang.authlib.GameProfile;
import java.util.Date;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.world.level.GameType;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;

public class ForgePlayer
implements OPanelPlayer {
    private final ServerPlayer player;
    private final PlayerList playerManager;
    private final GameProfile profile;

    public ForgePlayer(ServerPlayer player) {
        this.player = player;
        this.playerManager = player.m_20194_().m_6846_();
        this.profile = player.m_36316_();
    }

    @Override
    public String getName() {
        if (this.player == null) {
            return "";
        }
        return this.player.m_7755_().getString();
    }

    @Override
    public String getUUID() {
        if (this.player == null) {
            return null;
        }
        return this.player.m_20149_();
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public boolean isOp() {
        if (this.player == null) {
            return false;
        }
        return this.playerManager.m_11303_(this.profile);
    }

    @Override
    public boolean isBanned() {
        return false;
    }

    @Override
    public OPanelGameMode getGameMode() {
        if (this.player == null) {
            return null;
        }
        GameType gamemode = this.player.f_8941_.m_9290_();
        switch (gamemode) {
            case ADVENTURE: {
                return OPanelGameMode.ADVENTURE;
            }
            case SURVIVAL: {
                return OPanelGameMode.SURVIVAL;
            }
            case CREATIVE: {
                return OPanelGameMode.CREATIVE;
            }
            case SPECTATOR: {
                return OPanelGameMode.SPECTATOR;
            }
        }
        return null;
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        if (this.player == null) {
            return;
        }
        switch (gamemode) {
            case ADVENTURE: {
                this.player.m_143403_(GameType.ADVENTURE);
                break;
            }
            case SURVIVAL: {
                this.player.m_143403_(GameType.SURVIVAL);
                break;
            }
            case CREATIVE: {
                this.player.m_143403_(GameType.CREATIVE);
                break;
            }
            case SPECTATOR: {
                this.player.m_143403_(GameType.SPECTATOR);
            }
        }
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.playerManager.m_5749_(this.profile);
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.playerManager.m_5750_(this.profile);
    }

    @Override
    public void kick(String reason) {
        this.player.f_8906_.m_294716_(Component.m_130674_((String)reason));
    }

    @Override
    public void ban(String reason) {
        UserBanList bannedList = this.playerManager.m_11295_();
        UserBanListEntry entry = new UserBanListEntry(this.profile, new Date(), null, null, reason);
        bannedList.m_11381_((StoredUserEntry)entry);
        this.kick(reason);
    }

    @Override
    public String getBanReason() {
        return null;
    }

    @Override
    public void pardon() {
    }

    @Override
    public int getPing() {
        return this.player.f_8906_.m_293018_();
    }
}

