/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.neoforge_1_21_5;

import com.mojang.logging.LogUtils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.opanel.OPanel;
import net.opanel.neoforge_1_21_5.LoggerImpl;
import net.opanel.neoforge_1_21_5.NeoListener;
import net.opanel.neoforge_1_21_5.NeoServer;
import net.opanel.neoforge_1_21_5.command.OPanelCommand;
import net.opanel.neoforge_1_21_5.config.Config;
import net.opanel.neoforge_1_21_5.config.ConfigManagerImpl;
import net.opanel.neoforge_1_21_5.terminal.LogListenerManagerImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.slf4j.Logger;

@Mod(value="opanel", dist={Dist.DEDICATED_SERVER})
public class Main {
    public static final String MODID = "opanel";
    public static final Logger LOGGER = LogUtils.getLogger();
    public OPanel instance;
    private LogListenerManagerImpl logListenerAppender;

    public Main(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new NeoListener());
        this.initLogListenerAppender();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.instance = new OPanel(new ConfigManagerImpl(), new LoggerImpl(LOGGER));
        this.instance.setLogListenerManager(this.logListenerAppender);
        OPanelCommand.instance = this.instance;
    }

    private void initLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        this.logListenerAppender = LogListenerManagerImpl.createAppender("LogListenerAppender", true);
        this.logListenerAppender.start();
        logger.addAppender((Appender)this.logListenerAppender);
    }

    private void disposeLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        logger.removeAppender((Appender)this.logListenerAppender);
        this.logListenerAppender.clearListeners();
    }

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        if (this.instance == null) {
            throw new NullPointerException("OPanel is not initialized.");
        }
        this.instance.setServer(new NeoServer(event.getServer()));
        try {
            this.instance.getWebServer().start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        try {
            if (this.logListenerAppender != null) {
                this.disposeLogListenerAppender();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to dispose log listener appender: " + e.getMessage());
        }
        try {
            if (this.instance != null) {
                this.instance.stop();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to stop OPanel instance: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        if (this.instance == null) {
            throw new NullPointerException("OPanel is not initialized.");
        }
        this.instance.onTick();
    }
}

