/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.common.features;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.opanel.utils.Utils;

public interface BukkitConfigFeature {
    public static final Path bukkitConfigPath = Paths.get("", new String[0]).resolve("bukkit.yml");
    public static final Path spigotConfigPath = Paths.get("", new String[0]).resolve("spigot.yml");
    public static final Path paperGlobalConfigPath = Paths.get("", new String[0]).resolve("config/paper-global.yml");
    public static final Path paperWorldDefaultsConfigPath = Paths.get("", new String[0]).resolve("config/paper-world-defaults.yml");

    private Path getBukkitServerConfigPath(String target) throws NoSuchFileException {
        Path targetPath = switch (target) {
            case "bukkit" -> bukkitConfigPath;
            case "spigot" -> spigotConfigPath;
            case "paper" -> paperGlobalConfigPath;
            default -> throw new IllegalArgumentException("Unknown target name");
        };
        if (!Files.exists(targetPath, new LinkOption[0])) {
            throw new NoSuchFileException("Cannot find the target bukkit server config");
        }
        return targetPath;
    }

    private Path getPaperWorldConfigPath(String worldName) throws NoSuchFileException {
        Path targetPath = Paths.get("", new String[0]).resolve(worldName).resolve("paper-world.yml");
        if (!Files.exists(targetPath, new LinkOption[0])) {
            throw new NoSuchFileException("Cannot find the config of world " + worldName);
        }
        return targetPath;
    }

    default public String getBukkitServerConfigContent(String target) throws IOException {
        return Utils.readTextFile(this.getBukkitServerConfigPath(target));
    }

    default public void writeBukkitServerConfigContent(String target, String content) throws IOException {
        Utils.writeTextFile(this.getBukkitServerConfigPath(target), content);
    }

    default public String getPaperWorldDefaultsConfigContent() throws IOException {
        return Utils.readTextFile(paperWorldDefaultsConfigPath);
    }

    default public void writePaperWorldDefaultsConfigContent(String content) throws IOException {
        Utils.writeTextFile(paperGlobalConfigPath, content);
    }

    default public String getPaperWorldConfigContent(String worldName) throws IOException {
        return Utils.readTextFile(this.getPaperWorldConfigPath(worldName));
    }

    default public void writePaperWorldConfigContent(String worldName, String content) throws IOException {
        Utils.writeTextFile(this.getPaperWorldConfigPath(worldName), content);
    }
}

