/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_1_21_9;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_1267;
import net.minecraft.class_1940;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_31;
import net.minecraft.class_3176;
import net.minecraft.server.MinecraftServer;
import net.opanel.common.OPanelDifficulty;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.fabric_helper.BaseFabricSave;
import net.opanel.fabric_helper.FabricUtils;

public class FabricSave
extends BaseFabricSave
implements OPanelSave {
    private class_2487 nbt;

    public FabricSave(MinecraftServer server, Path path) {
        super(server, path);
        try {
            Optional optionalNbt = class_2507.method_30613((Path)this.savePath.resolve("level.dat"), (class_2505)class_2505.method_53899((long)0x200000L)).method_10580("Data").method_68571();
            if (optionalNbt.isEmpty()) {
                throw new IOException("Cannot find a valid level.dat");
            }
            this.nbt = (class_2487)optionalNbt.get();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void saveNbt() throws IOException {
        class_2487 dataNbt = new class_2487();
        dataNbt.method_10566("Data", (class_2520)this.nbt);
        class_2507.method_30614((class_2487)dataNbt, (Path)this.savePath.resolve("level.dat"));
    }

    @Override
    public String getDisplayName() {
        return this.nbt.method_68564("LevelName", "world").replaceAll("\u00c2", "");
    }

    @Override
    public void setDisplayName(String displayName) throws IOException {
        this.nbt.method_10582("LevelName", displayName);
        this.saveNbt();
    }

    @Override
    public OPanelGameMode getDefaultGameMode() {
        int gamemode = this.nbt.method_68083("GameType", 0);
        return OPanelGameMode.fromId(gamemode);
    }

    @Override
    public void setDefaultGameMode(OPanelGameMode gamemode) throws IOException {
        this.nbt.method_10569("GameType", gamemode.getId());
        this.saveNbt();
    }

    @Override
    public OPanelDifficulty getDifficulty() throws IOException {
        if (this.isCurrent()) {
            return OPanelDifficulty.fromId(this.getCurrentWorld().method_8407().method_5461());
        }
        byte difficulty = this.nbt.method_68562("Difficulty", (byte)0);
        return OPanelDifficulty.fromId(difficulty);
    }

    @Override
    public void setDifficulty(OPanelDifficulty difficulty) throws IOException {
        if (this.isCurrent()) {
            this.server.method_3776(class_1267.method_16691((String)difficulty.getName()), true);
        }
        this.nbt.method_10567("Difficulty", (byte)difficulty.getId());
        this.saveNbt();
    }

    @Override
    public boolean isDifficultyLocked() throws IOException {
        if (this.isCurrent()) {
            return this.getCurrentWorld().method_8401().method_197();
        }
        return this.nbt.method_68562("DifficultyLocked", (byte)0) == 1;
    }

    @Override
    public void setDifficultyLocked(boolean locked) throws IOException {
        if (this.isCurrent()) {
            this.server.method_19467(locked);
        }
        this.nbt.method_10567("DifficultyLocked", (byte)(locked ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public boolean isHardcore() throws IOException {
        if (this.isCurrent()) {
            return this.server.method_3754();
        }
        return this.nbt.method_68562("hardcore", (byte)0) == 1;
    }

    @Override
    public void setHardcoreEnabled(boolean enabled) throws IOException {
        if (this.isCurrent()) {
            class_31 levelProperties = (class_31)this.getCurrentWorld().method_8401();
            class_1940 currentInfo = levelProperties.method_27433();
            class_1940 newInfo = new class_1940(currentInfo.method_27339(), currentInfo.method_8574(), enabled, currentInfo.method_27340(), currentInfo.method_8582(), currentInfo.method_27341(), currentInfo.method_29558());
            try {
                Field levelInfoField = class_31.class.getDeclaredField("levelInfo");
                levelInfoField.setAccessible(true);
                levelInfoField.set(levelProperties, newInfo);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("hardcore=.+", "hardcore=" + enabled));
            FabricUtils.forceUpdateProperties((class_3176)this.server);
        }
        this.nbt.method_10567("hardcore", (byte)(enabled ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public HashMap<String, Boolean> getDatapacks() {
        HashMap<String, Boolean> datapacks = new HashMap<String, Boolean>();
        Optional optionalDatapacksNbt = this.nbt.method_10562("DataPacks");
        if (optionalDatapacksNbt.isEmpty()) {
            return datapacks;
        }
        class_2487 datapacksNbt = (class_2487)optionalDatapacksNbt.get();
        Optional optionalEnabledListNbt = datapacksNbt.method_10554("Enabled");
        Optional optionalDisabledListNbt = datapacksNbt.method_10554("Disabled");
        optionalEnabledListNbt.ifPresent(tags -> tags.forEach(tag -> datapacks.put((String)tag.method_68658().get(), true)));
        optionalDisabledListNbt.ifPresent(tags -> tags.forEach(tag -> datapacks.put((String)tag.method_68658().get(), false)));
        return datapacks;
    }

    @Override
    public void toggleDatapack(String id, boolean enabled) throws IOException {
        Optional optionalDatapacksNbt;
        Boolean currentEnabled = this.getDatapacks().get(id);
        if (currentEnabled == null || currentEnabled == enabled) {
            return;
        }
        if (id.equals("vanilla")) {
            return;
        }
        if (this.isCurrent()) {
            this.server.method_3734().method_44252(this.server.method_3739(), "datapack " + (enabled ? "enable" : "disable") + " \"" + id + "\"");
        }
        if ((optionalDatapacksNbt = this.nbt.method_10562("DataPacks")).isEmpty()) {
            return;
        }
        class_2487 datapacksNbt = (class_2487)optionalDatapacksNbt.get();
        Optional optionalEnabledListNbt = datapacksNbt.method_10554("Enabled");
        Optional optionalDisabledListNbt = datapacksNbt.method_10554("Disabled");
        if (enabled) {
            optionalDisabledListNbt.ifPresent(tags -> tags.remove((Object)class_2519.method_23256((String)id)));
            optionalEnabledListNbt.ifPresent(tags -> tags.add((Object)class_2519.method_23256((String)id)));
        } else {
            optionalEnabledListNbt.ifPresent(tags -> tags.remove((Object)class_2519.method_23256((String)id)));
            optionalDisabledListNbt.ifPresent(tags -> tags.add((Object)class_2519.method_23256((String)id)));
        }
        this.saveNbt();
    }
}

