/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_20_6;

import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.opanel.OPanel;
import net.opanel.forge_1_20_6.ForgeListener;
import net.opanel.forge_1_20_6.ForgeServer;
import net.opanel.forge_1_20_6.LoggerImpl;
import net.opanel.forge_1_20_6.command.OPanelCommand;
import net.opanel.forge_1_20_6.terminal.LogListenerManagerImpl;
import net.opanel.forge_helper.config.Config;
import net.opanel.forge_helper.config.ConfigManagerImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.slf4j.Logger;

@Mod(value="opanel")
@OnlyIn(value=Dist.DEDICATED_SERVER)
public class Main {
    public static final String MODID = "opanel";
    public static final Logger LOGGER = LogUtils.getLogger();
    public OPanel instance;
    private LogListenerManagerImpl logListenerAppender;

    public Main(FMLJavaModLoadingContext ctx) {
        ctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeListener());
        this.initLogListenerAppender();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.instance = new OPanel(new ConfigManagerImpl(), new LoggerImpl(LOGGER));
        this.instance.setLogListenerManager(this.logListenerAppender);
        OPanelCommand.instance = this.instance;
    }

    private void initLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        this.logListenerAppender = LogListenerManagerImpl.createAppender("LogListenerAppender", true);
        this.logListenerAppender.start();
        logger.addAppender((Appender)this.logListenerAppender);
    }

    private void disposeLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        logger.removeAppender((Appender)this.logListenerAppender);
        this.logListenerAppender.clearListeners();
    }

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        if (this.instance == null) {
            throw new NullPointerException("OPanel is not initialized.");
        }
        this.instance.setServer(new ForgeServer(event.getServer()));
        try {
            this.instance.getWebServer().start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        try {
            if (this.logListenerAppender != null) {
                this.disposeLogListenerAppender();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to dispose log listener appender: " + e.getMessage());
        }
        try {
            if (this.instance != null) {
                this.instance.stop();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to stop OPanel instance: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (this.instance == null) {
            throw new NullPointerException("OPanel is not initialized.");
        }
        this.instance.onTick();
    }
}

