/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_helper;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelServer;
import net.opanel.common.ServerType;

public abstract class BaseForgeServer
implements OPanelServer {
    protected final MinecraftServer server;

    public BaseForgeServer(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public ServerType getServerType() {
        return ServerType.FORGE;
    }

    @Override
    public String getMotd() {
        return this.server.getMotd();
    }

    @Override
    public void setMotd(String motd) throws IOException {
        this.server.setMotd(motd);
        String formatted = motd.replaceAll("\n", Matcher.quoteReplacement("\\n"));
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("motd=.+", Matcher.quoteReplacement("motd=" + formatted)));
    }

    @Override
    public String getVersion() {
        return this.server.getServerVersion();
    }

    @Override
    public int getPort() {
        return this.server.getPort();
    }

    @Override
    public void saveAll() {
        this.server.saveEverything(true, true, true);
    }

    @Override
    public int getMaxPlayerCount() {
        return this.server.getMaxPlayers();
    }

    @Override
    public OPanelPlayer getPlayer(String uuid) {
        for (OPanelPlayer player : this.getPlayers()) {
            if (!player.getUUID().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    @Override
    public void removePlayerData(String uuid) throws IOException {
        Path playerDataFolder = this.server.getWorldPath(LevelResource.PLAYER_DATA_DIR);
        Files.deleteIfExists(playerDataFolder.resolve(uuid + ".dat"));
        Files.deleteIfExists(playerDataFolder.resolve(uuid + ".dat_old"));
    }

    @Override
    public void sendServerCommand(String command) {
        Commands manager = this.server.getCommands();
        CommandSourceStack source = this.server.createCommandSourceStack();
        manager.performPrefixedCommand(source, command);
    }

    @Override
    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        CommandDispatcher dispatcher = this.server.getCommands().getDispatcher();
        for (CommandNode node : dispatcher.getRoot().getChildren()) {
            commands.add(node.getName());
        }
        return commands;
    }

    @Override
    public List<String> getCommandTabList(int argIndex, String command) {
        if (argIndex == 1) {
            return this.getCommands();
        }
        ArrayList<String> tabList = new ArrayList<String>();
        String[] args2 = command.split(" ");
        CommandDispatcher dispatcher = this.server.getCommands().getDispatcher();
        RootCommandNode currentNode = dispatcher.getRoot();
        for (int i = 0; i <= args2.length && currentNode != null; currentNode = currentNode.getChild(args2[i]), ++i) {
            if (i + 1 == argIndex) {
                for (CommandNode subNode : currentNode.getChildren()) {
                    tabList.add(subNode.getName());
                }
                break;
            }
            if (i == args2.length) break;
        }
        return tabList;
    }

    @Override
    public void reload() {
        this.sendServerCommand("reload");
    }

    @Override
    public void stop() {
        this.server.halt(false);
    }

    @Override
    public long getIngameTime() {
        return this.server.overworld().getDayTime();
    }
}

