/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.bukkit_helper;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Properties;
import net.opanel.bukkit_helper.TaskRunner;
import net.opanel.common.OPanelDifficulty;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.deps.nbtapi.NBT;
import net.opanel.deps.nbtapi.handler.NBTHandlers;
import net.opanel.deps.nbtapi.iface.ReadWriteNBT;
import net.opanel.utils.Utils;
import org.bukkit.Difficulty;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BaseBukkitSave
implements OPanelSave {
    protected final JavaPlugin plugin;
    protected final TaskRunner runner;
    protected final Server server;
    protected final Path savePath;
    protected ReadWriteNBT nbt;

    public BaseBukkitSave(JavaPlugin plugin, Server server, Path path) {
        this.plugin = plugin;
        this.runner = (TaskRunner)plugin;
        this.server = server;
        this.savePath = path;
        try {
            this.nbt = NBT.readFile(this.savePath.resolve("level.dat").toFile()).getCompound("Data");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void saveNbt() throws IOException {
        ReadWriteNBT dataNbt = NBT.createNBTObject();
        dataNbt.set("Data", this.nbt, NBTHandlers.STORE_READWRITE_TAG);
        NBT.writeFile(this.savePath.resolve("level.dat").toFile(), dataNbt);
    }

    protected World getCurrentWorld() {
        return (World)this.server.getWorlds().get(0);
    }

    @Override
    public String getName() {
        return this.savePath.getFileName().toString();
    }

    @Override
    public String getDisplayName() {
        return this.nbt.getString("LevelName").replaceAll("\u00c2", "");
    }

    @Override
    public void setDisplayName(String displayName) throws IOException {
        this.nbt.setString("LevelName", displayName);
        this.saveNbt();
    }

    @Override
    public Path getPath() {
        return this.savePath.toAbsolutePath();
    }

    @Override
    public long getSize() throws IOException {
        return Utils.getDirectorySize(this.savePath);
    }

    @Override
    public boolean isRunning() {
        return this.getCurrentWorld().getName().equals(this.getName());
    }

    @Override
    public boolean isCurrent() throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(OPanelServer.serverPropertiesPath.toFile()));
        return properties.getProperty("level-name").replaceAll("\u00c2", "").equals(this.getName());
    }

    @Override
    public void setToCurrent() throws IOException {
        if (this.isCurrent()) {
            return;
        }
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("level-name=.+", "level-name=" + this.getName()));
    }

    @Override
    public OPanelGameMode getDefaultGameMode() {
        int gamemode = this.nbt.getInteger("GameType");
        return OPanelGameMode.fromId(gamemode);
    }

    @Override
    public void setDefaultGameMode(OPanelGameMode gamemode) throws IOException {
        this.nbt.setInteger("GameType", gamemode.getId());
        this.saveNbt();
    }

    @Override
    public OPanelDifficulty getDifficulty() throws IOException {
        if (this.isCurrent()) {
            return OPanelDifficulty.fromId(this.getCurrentWorld().getDifficulty().getValue());
        }
        byte difficulty = this.nbt.getByte("Difficulty");
        return OPanelDifficulty.fromId(difficulty);
    }

    @Override
    public void setDifficulty(OPanelDifficulty difficulty) throws IOException {
        if (this.isCurrent()) {
            this.runner.runTask(() -> {
                switch (difficulty) {
                    case PEACEFUL: {
                        this.getCurrentWorld().setDifficulty(Difficulty.PEACEFUL);
                        break;
                    }
                    case EASY: {
                        this.getCurrentWorld().setDifficulty(Difficulty.EASY);
                        break;
                    }
                    case NORMAL: {
                        this.getCurrentWorld().setDifficulty(Difficulty.NORMAL);
                        break;
                    }
                    case HARD: {
                        this.getCurrentWorld().setDifficulty(Difficulty.HARD);
                    }
                }
            });
        }
        this.nbt.setByte("Difficulty", (byte)difficulty.getId());
        this.saveNbt();
    }

    @Override
    public boolean isDifficultyLocked() {
        return this.nbt.getByte("DifficultyLocked") == 1;
    }

    @Override
    public void setDifficultyLocked(boolean locked) throws IOException {
        this.nbt.setByte("DifficultyLocked", (byte)(locked ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public boolean isHardcore() throws IOException {
        if (this.isCurrent()) {
            return this.getCurrentWorld().isHardcore();
        }
        return this.nbt.getByte("hardcore") == 1;
    }

    @Override
    public void setHardcoreEnabled(boolean enabled) throws IOException {
        if (this.isCurrent()) {
            this.runner.runTask(() -> this.getCurrentWorld().setHardcore(enabled));
        }
        this.nbt.setByte("hardcore", (byte)(enabled ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public HashMap<String, Boolean> getDatapacks() {
        HashMap<String, Boolean> datapacks = new HashMap<String, Boolean>();
        ReadWriteNBT datapacksNbt = this.nbt.getCompound("DataPacks");
        datapacksNbt.getStringList("Enabled").forEach(name -> datapacks.put((String)name, true));
        datapacksNbt.getStringList("Disabled").forEach(name -> datapacks.put((String)name, false));
        return datapacks;
    }

    @Override
    public void toggleDatapack(String id, boolean enabled) throws IOException {
        Boolean currentEnabled = this.getDatapacks().get(id);
        if (currentEnabled == null || currentEnabled == enabled) {
            return;
        }
        if (id.equals("vanilla")) {
            return;
        }
        if (this.isCurrent()) {
            this.runner.runTask(() -> this.server.dispatchCommand((CommandSender)this.server.getConsoleSender(), "datapack " + (enabled ? "enable" : "disable") + " \"" + id + "\""));
        }
        ReadWriteNBT datapacksNbt = this.nbt.getCompound("DataPacks");
        if (enabled) {
            datapacksNbt.getStringList("Disabled").remove(id);
            datapacksNbt.getStringList("Enabled").add(id);
        } else {
            datapacksNbt.getStringList("Enabled").remove(id);
            datapacksNbt.getStringList("Disabled").add(id);
        }
        this.saveNbt();
    }

    @Override
    public void delete() throws IOException {
        Utils.deleteDirectoryRecursively(this.savePath);
    }
}

