/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.deps.oshi.hardware.platform.windows;

import java.util.List;
import net.opanel.deps.oshi.annotation.concurrent.ThreadSafe;
import net.opanel.deps.oshi.hardware.CentralProcessor;
import net.opanel.deps.oshi.hardware.ComputerSystem;
import net.opanel.deps.oshi.hardware.Display;
import net.opanel.deps.oshi.hardware.GlobalMemory;
import net.opanel.deps.oshi.hardware.GraphicsCard;
import net.opanel.deps.oshi.hardware.HWDiskStore;
import net.opanel.deps.oshi.hardware.LogicalVolumeGroup;
import net.opanel.deps.oshi.hardware.NetworkIF;
import net.opanel.deps.oshi.hardware.PowerSource;
import net.opanel.deps.oshi.hardware.Sensors;
import net.opanel.deps.oshi.hardware.SoundCard;
import net.opanel.deps.oshi.hardware.UsbDevice;
import net.opanel.deps.oshi.hardware.common.AbstractHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsCentralProcessor;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsComputerSystem;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsDisplay;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsGlobalMemory;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsGraphicsCard;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsHWDiskStore;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsLogicalVolumeGroup;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsNetworkIF;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsPowerSource;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsSensors;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsSoundCard;
import net.opanel.deps.oshi.hardware.platform.windows.WindowsUsbDevice;

@ThreadSafe
public final class WindowsHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    @Override
    public ComputerSystem createComputerSystem() {
        return new WindowsComputerSystem();
    }

    @Override
    public GlobalMemory createMemory() {
        return new WindowsGlobalMemory();
    }

    @Override
    public CentralProcessor createProcessor() {
        return new WindowsCentralProcessor();
    }

    @Override
    public Sensors createSensors() {
        return new WindowsSensors();
    }

    @Override
    public List<PowerSource> getPowerSources() {
        return WindowsPowerSource.getPowerSources();
    }

    @Override
    public List<HWDiskStore> getDiskStores() {
        return WindowsHWDiskStore.getDisks();
    }

    @Override
    public List<LogicalVolumeGroup> getLogicalVolumeGroups() {
        return WindowsLogicalVolumeGroup.getLogicalVolumeGroups();
    }

    @Override
    public List<Display> getDisplays() {
        return WindowsDisplay.getDisplays();
    }

    @Override
    public List<NetworkIF> getNetworkIFs(boolean includeLocalInterfaces) {
        return WindowsNetworkIF.getNetworks(includeLocalInterfaces);
    }

    @Override
    public List<UsbDevice> getUsbDevices(boolean tree) {
        return WindowsUsbDevice.getUsbDevices(tree);
    }

    @Override
    public List<SoundCard> getSoundCards() {
        return WindowsSoundCard.getSoundCards();
    }

    @Override
    public List<GraphicsCard> getGraphicsCards() {
        return WindowsGraphicsCard.getGraphicsCards();
    }
}

