/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.folia_1_20;

import net.opanel.common.OPanelGameMode;
import net.opanel.event.EventManager;
import net.opanel.event.EventType;
import net.opanel.event.OPanelPlayerGameModeChangeEvent;
import net.opanel.event.OPanelPlayerJoinEvent;
import net.opanel.event.OPanelPlayerLeaveEvent;
import net.opanel.folia_1_20.FoliaPlayer;
import net.opanel.folia_1_20.Main;
import org.bukkit.GameMode;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class FoliaListener
implements Listener {
    private final Main plugin;

    public FoliaListener(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        EventManager.get().emit(EventType.PLAYER_JOIN, new OPanelPlayerJoinEvent(new FoliaPlayer(this.plugin, event.getPlayer())));
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        EventManager.get().emit(EventType.PLAYER_LEAVE, new OPanelPlayerLeaveEvent(new FoliaPlayer(this.plugin, event.getPlayer())));
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        GameMode gamemode = event.getNewGameMode();
        EventManager.get().emit(EventType.PLAYER_GAMEMODE_CHANGE, new OPanelPlayerGameModeChangeEvent(new FoliaPlayer(this.plugin, event.getPlayer()), switch (gamemode) {
            case GameMode.ADVENTURE -> OPanelGameMode.ADVENTURE;
            case GameMode.SURVIVAL -> OPanelGameMode.SURVIVAL;
            case GameMode.CREATIVE -> OPanelGameMode.CREATIVE;
            case GameMode.SPECTATOR -> OPanelGameMode.SPECTATOR;
            default -> null;
        }));
    }
}

