/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.folia_1_20;

import net.opanel.bukkit_helper.BaseBukkitPlayer;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import net.opanel.folia_1_20.Main;
import org.bukkit.BanList;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FoliaPlayer
extends BaseBukkitPlayer
implements OPanelPlayer {
    public FoliaPlayer(Main plugin, Player player) {
        super(plugin, player);
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        this.player.getScheduler().run((Plugin)this.plugin, task -> {
            switch (gamemode) {
                case ADVENTURE: {
                    this.player.setGameMode(GameMode.ADVENTURE);
                    break;
                }
                case SURVIVAL: {
                    this.player.setGameMode(GameMode.SURVIVAL);
                    break;
                }
                case CREATIVE: {
                    this.player.setGameMode(GameMode.CREATIVE);
                    break;
                }
                case SPECTATOR: {
                    this.player.setGameMode(GameMode.SPECTATOR);
                }
            }
        }, null);
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.player.getScheduler().run((Plugin)this.plugin, task -> this.player.setOp(true), null);
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.player.getScheduler().run((Plugin)this.plugin, task -> this.player.setOp(false), null);
    }

    @Override
    public void kick(String reason) {
        this.player.getScheduler().run((Plugin)this.plugin, task -> this.player.kickPlayer(reason), null);
    }

    @Override
    public void ban(String reason) {
        if (this.isBanned()) {
            return;
        }
        this.player.getScheduler().run((Plugin)this.plugin, task -> {
            this.player.getServer().getBanList(BanList.Type.NAME).addBan(this.player.getName(), reason, null, null);
            this.player.kickPlayer(reason);
        }, null);
    }

    @Override
    public int getPing() {
        return this.player.getPing();
    }
}

