/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.io.IOException;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.controller.BaseController;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.deps.oshi.SystemInfo;
import net.opanel.time.TPS;
import net.opanel.utils.Utils;

public class InfoController
extends BaseController {
    private final SystemInfo si = new SystemInfo();
    public Handler getServerInfo = ctx -> {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("favicon", this.server.getFavicon() != null ? "/api/icon?t=" + System.currentTimeMillis() : null);
        obj.put("motd", Utils.stringToBase64(this.server.getMotd()));
        obj.put("port", this.server.getPort());
        obj.put("maxPlayerCount", this.server.getMaxPlayerCount());
        obj.put("whitelist", this.server.isWhitelistEnabled());
        obj.put("uptime", this.plugin.getUptimer().getCurrent());
        HashMap<String, Object> ingameTimeObj = new HashMap<String, Object>();
        ingameTimeObj.put("current", this.server.getIngameTime());
        ingameTimeObj.put("doDaylightCycle", this.server.getGamerules().get("doDaylightCycle"));
        ingameTimeObj.put("paused", TPS.isPaused());
        ingameTimeObj.put("mspt", TPS.getRecentMSPT());
        obj.put("ingameTime", ingameTimeObj);
        HashMap<String, Object> sysObj = new HashMap<String, Object>();
        sysObj.put("os", this.si.getOperatingSystem().toString());
        sysObj.put("arch", System.getProperty("os.arch"));
        sysObj.put("cpuName", this.si.getHardware().getProcessor().getProcessorIdentifier().getName().trim());
        sysObj.put("cpuCore", this.si.getHardware().getProcessor().getPhysicalProcessorCount());
        sysObj.put("memory", this.si.getHardware().getMemory().getTotal());
        sysObj.put("gpus", this.si.getHardware().getGraphicsCards().stream().map(gpu -> gpu.getName().trim()).toArray());
        sysObj.put("java", System.getProperty("java.version"));
        obj.put("system", sysObj);
        this.sendResponse(ctx, obj);
    };
    public Handler setMotd = ctx -> {
        try {
            String motd = ctx.bodyAsClass(String.class);
            if (motd.isEmpty() || motd.trim().isEmpty()) {
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Motd is missing.");
                return;
            }
            this.server.setMotd(Utils.base64ToString(motd));
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IOException e) {
            this.plugin.logger.error("Failed to update motd: " + e.getMessage());
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.plugin.logger.error("Invalid Base64 encoding in motd: " + e.getMessage());
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Invalid Base64 encoding in motd.");
        }
    };

    public InfoController(OPanel plugin) {
        super(plugin);
    }
}

