/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_1_20_3;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2926;
import net.minecraft.class_3222;
import net.minecraft.class_3320;
import net.minecraft.class_3330;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.common.OPanelWhitelist;
import net.opanel.fabric_1_20_3.FabricOfflinePlayer;
import net.opanel.fabric_1_20_3.FabricPlayer;
import net.opanel.fabric_1_20_3.FabricSave;
import net.opanel.fabric_1_20_3.FabricWhitelist;
import net.opanel.fabric_1_20_3.Main;
import net.opanel.fabric_helper.BaseFabricServer;
import net.opanel.utils.Utils;

public class FabricServer
extends BaseFabricServer
implements OPanelServer {
    public FabricServer(MinecraftServer server) {
        super(server);
    }

    @Override
    public byte[] getFavicon() {
        byte[] serverIconPNG = super.getFavicon();
        if (serverIconPNG != null) {
            return serverIconPNG;
        }
        class_2926 metadata = this.server.method_3765();
        if (metadata == null) {
            return null;
        }
        Optional faviconOptional = metadata.comp_1276();
        if (faviconOptional.isEmpty()) {
            return null;
        }
        class_2926.class_8145 favicon = (class_2926.class_8145)faviconOptional.get();
        return favicon.comp_1278();
    }

    @Override
    public void setFavicon(byte[] iconBytes) throws IOException {
        super.setFavicon(iconBytes);
        class_2926 metadata = this.server.method_3765();
        class_2926.class_8145 favicon = new class_2926.class_8145(iconBytes);
        class_2926 newStatus = new class_2926(metadata.comp_1273(), metadata.comp_1274(), metadata.comp_1275(), Optional.of(favicon), metadata.comp_1277());
        try {
            Field faviconField = MinecraftServer.class.getDeclaredField("field_42958");
            faviconField.setAccessible(true);
            faviconField.set(this.server, favicon);
            Field metadataField = MinecraftServer.class.getDeclaredField("field_4593");
            metadataField.setAccessible(true);
            metadataField.set(this.server, newStatus);
        }
        catch (Exception e) {
            Main.LOGGER.warn("Cannot reload server favicon.");
        }
    }

    @Override
    public List<OPanelSave> getSaves() {
        ArrayList<OPanelSave> list = new ArrayList<OPanelSave>();
        try (Stream<Path> stream = Files.list(Paths.get("", new String[0]));){
            stream.filter(path -> Files.exists(path.resolve("level.dat"), new LinkOption[0]) && !Files.isDirectory(path.resolve("level.dat"), new LinkOption[0])).map(Path::toAbsolutePath).forEach(path -> {
                FabricSave save = new FabricSave(this.server, (Path)path);
                list.add(save);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public OPanelSave getSave(String saveName) {
        Path savePath = Paths.get("", new String[0]).resolve(saveName);
        if (!Files.exists(savePath, new LinkOption[0]) || !Files.exists(savePath.resolve("level.dat"), new LinkOption[0])) {
            return null;
        }
        return new FabricSave(this.server, savePath.toAbsolutePath());
    }

    @Override
    public List<OPanelPlayer> getOnlinePlayers() {
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>();
        List players = this.server.method_3760().method_14571();
        for (class_3222 serverPlayer : players) {
            FabricPlayer player = new FabricPlayer(serverPlayer);
            list.add(player);
        }
        return list;
    }

    @Override
    public List<OPanelPlayer> getPlayers() {
        Path playerDataPath = this.server.method_27050(class_5218.field_24182);
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>(this.getOnlinePlayers());
        try (Stream<Path> stream = Files.list(playerDataPath);){
            stream.filter(item -> !Files.isDirectory(item, new LinkOption[0]) && item.toString().endsWith(".dat")).forEach(item -> {
                try {
                    String uuid = item.getFileName().toString().replace(".dat", "");
                    class_3222 serverPlayer = this.server.method_3760().method_14602(UUID.fromString(uuid));
                    if (serverPlayer != null && !serverPlayer.method_14239()) {
                        return;
                    }
                    FabricOfflinePlayer player = new FabricOfflinePlayer(this.server, UUID.fromString(uuid));
                    list.add(player);
                }
                catch (Exception e) {
                    Main.LOGGER.warn("Cannot read the player data from " + String.valueOf(item.getFileName()) + ": " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<String> getBannedIps() {
        Collection entries = this.server.method_3760().method_14585().method_14632();
        ArrayList<String> list = new ArrayList<String>();
        entries.forEach(entry -> list.add(entry.method_14504().getString()));
        return list;
    }

    @Override
    public void banIp(String ip2) {
        if (this.getBannedIps().contains(ip2)) {
            return;
        }
        this.server.method_3760().method_14585().method_14633((class_3330)new class_3320(ip2));
    }

    @Override
    public void pardonIp(String ip2) {
        if (!this.getBannedIps().contains(ip2)) {
            return;
        }
        this.server.method_3760().method_14585().method_14635((Object)ip2);
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.server.method_3760().method_14614();
    }

    @Override
    public void setWhitelistEnabled(boolean enabled) {
        this.server.method_3760().method_14557(enabled);
    }

    @Override
    public OPanelWhitelist getWhitelist() {
        return new FabricWhitelist(this.server.method_3760().method_14590());
    }

    @Override
    public void sendServerCommand(String command) {
        class_2170 manager = this.server.method_3734();
        class_2168 source = this.server.method_3739();
        manager.method_44252(source, command);
    }

    @Override
    public HashMap<String, Object> getGamerules() {
        class_2487 gamerulesNbt = this.server.method_3767().method_8358();
        HashMap<String, Object> gamerules = new HashMap<String, Object>();
        for (String key : gamerulesNbt.method_10541()) {
            String valueStr = gamerulesNbt.method_10558(key);
            if (valueStr.equals("true") || valueStr.equals("false")) {
                gamerules.put(key, Boolean.valueOf(valueStr));
                continue;
            }
            if (Utils.isNumeric(valueStr)) {
                gamerules.put(key, Integer.valueOf(valueStr));
                continue;
            }
            gamerules.put(key, valueStr);
        }
        return gamerules;
    }

    @Override
    public void setGamerules(final HashMap<String, Object> gamerules) {
        final HashMap<String, Object> currentGamerules = this.getGamerules();
        final class_1928 gameRulesObj = this.server.method_3767();
        class_1928.method_20744((class_1928.class_4311)new class_1928.class_4311(){

            public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                super.method_20762(key, type);
                String ruleName = key.method_20771();
                Object value = gamerules.get(ruleName);
                if (value == null) {
                    return;
                }
                Object currentValue = currentGamerules.get(ruleName);
                if (value.equals(currentValue)) {
                    return;
                }
                class_1928.class_4315 rule = type.method_20773();
                if (rule instanceof class_1928.class_4310) {
                    ((class_1928.class_4310)rule).method_20758(((Boolean)value).booleanValue(), FabricServer.this.server);
                    gameRulesObj.method_20746(key).method_27337(rule, FabricServer.this.server);
                } else if (rule instanceof class_1928.class_4312) {
                    int n = ((Number)value).intValue();
                    ((class_1928.class_4312)rule).method_35236(n, FabricServer.this.server);
                    gameRulesObj.method_20746(key).method_27337(rule, FabricServer.this.server);
                } else if (rule instanceof DoubleRule || value instanceof String) {
                    FabricServer.this.sendServerCommand("gamerule " + ruleName + " " + String.valueOf(value));
                }
            }
        });
    }
}

