/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_helper;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.utils.Utils;

public abstract class BaseForgeSave
implements OPanelSave {
    protected final MinecraftServer server;
    protected final Path savePath;

    public BaseForgeSave(MinecraftServer server, Path path) {
        this.server = server;
        this.savePath = path;
    }

    protected abstract void saveNbt() throws IOException;

    protected ServerLevel getCurrentWorld() {
        return this.server.m_129783_();
    }

    @Override
    public String getName() {
        return this.savePath.getFileName().toString();
    }

    @Override
    public Path getPath() {
        return this.savePath.toAbsolutePath();
    }

    @Override
    public long getSize() throws IOException {
        return Utils.getDirectorySize(this.savePath);
    }

    @Override
    public boolean isRunning() {
        return this.server.m_129843_(LevelResource.f_78178_).getParent().getFileName().toString().equals(this.getName());
    }

    @Override
    public boolean isCurrent() throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(OPanelServer.serverPropertiesPath.toFile()));
        return properties.getProperty("level-name").replaceAll("\u00c2", "").equals(this.getName());
    }

    @Override
    public void setToCurrent() throws IOException {
        if (this.isCurrent()) {
            return;
        }
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("level-name=.+", "level-name=" + this.getName()));
    }

    @Override
    public void delete() throws IOException {
        Utils.deleteDirectoryRecursively(this.savePath);
    }
}

